#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_node_ip_config
# Description : check the node ip config.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function get_networknumber()
{
    ip=$1
    mask=$2
    out=''
    for index in {1..4}; do
        si=$(echo $ip | cut -d "." -f $index)
        sm=$(echo $mask | cut -d "." -f $index)
        if [ $index -ne 1 ]; then
            out="$out."
        fi
        out="$out$[$si&$sm]"
    done
    echo $out
}

function check_ip_on_same_segment()
{
    ip1=$1
    ip2=$2
    mask=$3
    ip1_networknumber=`get_networknumber $ip1 $mask`
    ip2_networknumber=`get_networknumber $ip2 $mask`
    if [ ${ip1_networknumber} != ${ip2_networknumber} ]; then
        print_log "ERROR" "Please check whether the IP(${ip1}) is the same as network segment as the IP(${ip2})."
        ((error_fail_num=error_fail_num+1))
    fi
}

function check_node_ip_config
{
    typeset -i error_fail_num=0

    if [[ ${plane} == "plane_triple" ]]; then
        internal_netcard_ip_check=`ifconfig ${internal_nic} | grep ${internal_netcard_ip}`
        if [[ -z ${internal_netcard_ip_check} ]]; then
            print_log "ERROR" "The internal netcard [${internal_nic}] may be wrong. Please check if the internal netcard of the internal ip [${internal_netcard_ip}] is [${internal_nic}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    if [[ ${plane} != "plane_single" ]]; then
        south_netcard_ip_check=`ifconfig ${south_nic} | grep ${south_netcard_ip}`
        if [[ -z ${south_netcard_ip_check} ]]; then
            print_log "ERROR" "The south netcard [${south_nic}] may be wrong. Please check if the south netcard of the south ip [${south_netcard_ip}] is [${south_nic}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi
    north_netcard_ip_check=`ifconfig ${north_nic} | grep ${north_netcard_ip}`
    if [[ -z ${north_netcard_ip_check} ]]; then
        print_log "ERROR" "The north netcard [${north_nic}] may be wrong. Please check if the north netcard of the north ip [${north_netcard_ip}] is [${north_nic}]."
        ((error_fail_num=error_fail_num+1))
    fi

    if [[ ${plane} != "plane_single" ]]; then
        south_mask_check=`ifconfig ${south_nic} | grep ${south_mask}`
        if [[ -z ${south_mask_check} ]]; then
            print_log "ERROR" "The south mask ip [${south_mask}] is wrong. Please check if the mask of the southbound network card is [${south_mask}]."
            ((error_fail_num=error_fail_num+1))
        fi
    fi

    north_mask_check=`ifconfig ${north_nic} | grep ${north_mask}`
    if [[ -z ${north_mask_check} ]]; then
        print_log "ERROR" "The north mask ip [${north_mask}] is wrong. Please check if the mask of the northbound network card is [${north_mask}]."
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]; then
        return 1
    fi

    return 0
}