#./bin/bash 
is_backup_site=$1


function print_log()
{
    level=$1
    message=$2
    current_time=`date '+%Y-%m-%d %H:%M:%S'`
    echo "${current_time} ${level} ${message}"
}

print_log "INFO" "Checking port mirror installation environment."

typeset -i fail_num=0

if [[ ${is_backup_site} == "backup_site_disable" ]]; then
    tenant=`ps -ef |grep DCNOpenEMService|grep -i tomcat | awk -F -DTOMCAT_LOG_DIR=/opt/oss/log/ '{print $2}' | awk '{print $1}'| awk -F / '{print $1}'`
    if [[ -z ${tenant} ]]; then
        print_log "ERROR" "DCNOpenEMService does not exist, please check it."
        ((fail_num=fail_num+1))
    fi
fi

if [ ${fail_num} -gt 0 ]
then
    print_log "ERROR" "===========================CHECKING ENVIRONMENT FAILED=============================="
    print_log "ERROR" "===================================================================================="
    print_log "ERROR" "" >&2
    exit 1
else
    print_log "INFO" "===========================CHECKING ENVIRONMENT SUCCESSFULLY========================"
    print_log "INFO" "===================================================================================="
    exit 0
fi
