#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_memory_space
# Description : check the free memory is enough or not.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_memory_space
{
    ram_size=`free -m | grep "Mem" | awk '{print $2}'`
    
    # for minimum system centos,if not fit,fix
    if [ "X${ram_size}" == "X" ];then
        ifavailable=`free -m | grep available`
        if [ "X${ifavailable}" != "X" ]; then
            ram_size=`free -m | grep Mem | awk '{print $NF}'`
        fi
    fi
    
    if [ "X${memory_space}" == "X" ];then
		print_log "WARNING" "Memory value to be checked is not configured, skip check memory space."
        return 0
    fi
	local expected_num=`echo "scale=1;(${memory_space} - 1) * 0.98" | bc`
    #adapt to kylin OS 
    if [ -f /etc/kylin-release ];then
        expected_num=$(echo "scale=1;(${memory_space} - 1) * 0.92" | bc)
    fi

    ram_size_g=`echo "scale=1;${ram_size} / 1024" | bc`
    if [[ `echo "${ram_size_g} < ${expected_num}" | bc` -eq 1 ]]; then
		print_log "ERROR" "OS memory ${ram_size_g}G is insufficient. ${expected_num}G of memory is required."
		print_log "ERROR" "------------------------------------------------------------------------------------"
		print_log "ERROR" "Memory is insufficient for the controller. If you proceed, the installation may fail."
		print_log "ERROR" "Even if the installation is successful, the controller may later go down due to lack"
		print_log "ERROR" "of memory. You are advised to increase available memory before installation."
		print_log "ERROR" "------------------------------------------------------------------------------------"
        return 1
    fi
	print_log "INFO" "Memory check successfully. The os total memory is ${ram_size_g}G, expected memory is ${expected_num}G."
    return 0
}