#!/bin/bash
. ./controller.inc
if [ `echo $0 | grep -c "/"` -gt 0 ];then
    cd ${0%/*}     
fi

################################################################################
# Function    : check_os_ip
# Description : check os ip.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_os_ip
{
    for ((i=1;i<=8;i++))
        do
            ip=`echo $ip_list | awk -F ',' '{print ${$i}'`
            echo $ip | egrep -o "(\<([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\>\.){3}\<([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\>"
            if [ $? -eq 0 ]
            then
                ifconfig | grep $ip
                if [ $? -eq 0 ]
                    echo "Checking ip address ${ip} successfully." >&1
                else
                    echo "IP address ${ip} verify failed." >&2
            fi
    ls /etc/sysconfig/network/routes
    if [ $? -eq 0 ]
    then
        echo "Checking route file successfully." >&1
    else
        echo "Checking route file failed." >&2
    fi
}
