##########################################################################
# Copyright (c) Huawei Technologies Co., Ltd. 2012. All rights reserved.
#以下参数请根据规划修改
##########################################################################
#!/bin/bash
precheckSharePath="/opt/pre-check"
CheckResultFile="${precheckSharePath}/CheckResultFile.txt"

suse_supported_version=("12.4" "12.5")
euler_supported_version=("2.0 (SP10)" "2.0 (SP10x86_64)")
centos_supported_version=("7.3" "7.4" "7.5" "7.6")
kylin_supported_version=("V10")
cpu_num="cpu_num_value"
memory_space="memory_space_value"
disk_size="disk_size_value"
add_disk="add_disk_size"
#disk_io="disk_io_value"
target_direction_list=('/boot' '/' '/home' '/tmp' '/usr' '/var' '/var/log' '/var/log/audit' '/var/tmp')
_tmp_size="9*1024"
_var_size="4*1024"
_usr_size="1.5*1024"
_var_log_size="5*1024"
_var_log_audit_size="0.5*1024"
swap_size="30*1024"
_reserved_size="10*1024"
_home_size="800"
_boot_size="600"
_var_tmp_size="4*1024"
_root_size="17*1024"
_opt_minimum_size="50*1024"
#  _except_opt_size: 92 * 1024"
_except_opt_size="94208"

_tmp_inode_size="600000"
_var_inode_size="250000"
_usr_inode_size="100000"
_var_log_inode_size="600000"
_var_log_audit_inode_size="120000"
_home_inode_size="50000"
_boot_inode_size="50000"
_var_tmp_inode_size="250000"
_root_inode_size="1000000"
_opt_inode=50000


# 读写大文件速率基线（100MB/s）
disk_io="100"
hostname="hostname_value"
ip_list="ip_list_value"

#==============================================================
## @Usage func_name  size(P,T,G,M,K,B)
## @Return ${SUCCESS_CODE}
## @Description transfer the disk size in GB format.
## input is $1(with unit), $2(GB format)
#==============================================================
function fn_get_size_GB()
{
    local quant=`echo $1 | grep -E '[0-9.]+' -o`
    local unit=`echo $1 | grep -E '[PTGMKB]' -o`
    case ${unit} in
    "P")
        echo `echo "${quant}*1024*1024" | bc`
        ;;
    "T")
        echo `echo "${quant}*1024" | bc`
        ;;
    "G")
        echo `echo "${quant}" | bc`
        ;;
    "M")
        echo `echo "scale=2;${quant}/1024" | bc`
        ;;
    "K")
        echo `echo "scale=2;${quant}/1024/1024" | bc`
        ;;
    "B")
        echo `echo "scale=2;${quant}/1024/1024/1024" | bc`
        ;;
    esac
    return 0
}

function print_log()
{
    level=$1
    message=$2
    current_time=`date '+%Y-%m-%d %H:%M:%S'`
    echo "${current_time} ${level} ${message}"
}
