#!/bin/bash

MODULE_NAME="$(basename $0)"

GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}

wirteFailedResultFile()
{
    echo "RESULT:255">"$set_backup_server_result"
 
}

wirteInitialResultFile()
{
    echo "RESULT:0">"$set_backup_server_result"
    chmod 640 $set_backup_server_result
 
}

wirteSuccessResultFile()
{
    echo "RESULT:100">"$set_backup_server_result"
 
}

Main()
{
    # current path   
    GetWorkPath
    
    set_backup_server_result="$curPath/output/check_set_backup_server.flag"
    
    wirteInitialResultFile

    backup_server_json=$1
    if [ ! -f "$backup_server_json" ];then
        wirteFailedResultFile
        return 1
    fi

    bash /opt/oss/manager/tools/backuprestore/setglobalpara.sh -input "$backup_server_json" >> "$curPath"/output/${MODULE_NAME}.log
    if [ $? -ne 0 ];then
       wirteFailedResultFile
       return 1
    fi

    wirteSuccessResultFile
    return 0
   
}

Main $*
exit $?