#!/bin/bash
#########################################
# 功能描述：检查当前节点是OMP并且为主节点
#########################################

function check_omp()
{
    local omp_node="False"

    local managerips=$(grep "^managerip" /opt/oss/manager/var/agent/managerip.conf | awk -F'=' '{print $2}' | sed 's/,/ /g')
    for mgrip in ${managerips}
    do
        ifconfig | grep "${mgrip}" &>/dev/null
        if [ $? -eq 0 ];then
            local omp_node="True"
        fi
    done

    local master="False"
    ifconfig | grep "eth.*:1" &>/dev/null
    if [ $? -eq 0 ]
    then
        local master="True"
    fi

    if [ "${omp_node}" == "True" -a "${master}" == "True" ]
    then
        echo "check is OMP master success"
        exit 0
    fi
    echo "check is OMP master failure"
    exit 1
}

check_omp
