#!/bin/bash

#get current time
function getTime()
{
    MONTH=`date +%m`
    DAY=`date +%d`
    HOUR=`date +%H`
    MIN=`date +%M`
    Time="$MONTH""$DAY""$HOUR""$MIN"
    echo "$Time"
}

#记录脚本日志
function writeLog()
{
    echo "$1" | awk -F"|" '{print substr($2,2)}'
    echo "`date +%F` `date +%R` || $1">>$LOG
}

#初始化日志
function initLog()
{
    curTime=`getTime`
    LOG=/var/log/NCEpostscript.log
}

#处理X86场景下FC8.0以下版本全局上下电虚拟机漂移问题
function checkPendingvalue()
{
    cat /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/host-filter.properties |grep "NetworkHostFilter,PendingHostFilter"
    if [ $? -eq 0 ]
    then
        writeLog "checkPendingvalue()| INFO:Begin to config host-filter.properties about the PendingHostFilter."
        sed -i 's/NetworkHostFilter,PendingHostFilter/NetworkHostFilter/g' /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/host-filter.properties
        if [ $? -eq 0 ]
        then
            writeLog "checkPendingvalue()| INFO:Success to config vrmconfig.properties about the PendingHostFilter."
            return 0
        else
            writeLog "checkPendingvalue()| FATAL:Failed to config vrmconfig.properties about the PendingHostFilter."
            return 1
        fi
    else
        writeLog "checkPendingvalue()| INFO:Skip to config vrmconfig.properties about the PendingHostFilter."
        return 0
    fi    
}
#修改X86场景下drs规则组不够的问题
function checkDrsvalue()
{
    cat /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/drsconfig.properties |grep "drs_rules_num_limit=20"
    if [ $? -eq 0 ]
    then
        writeLog "checkDrsvalue()| INFO:The drs_rules_num_limit is 20. Begin to change drs_rules_num_limit to 100."
        sed -i 's/drs_rules_num_limit=20/drs_rules_num_limit=100/g' /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/drsconfig.properties
        if [ $? -eq 0 ]
        then
            writeLog "checkDrsvalue()| INFO:Success to change drs_rules_num_limit to 100."
            return 0
        else
            writeLog "checkDrsvalue()| FATAL:Failed to change drs_rules_num_limit."
            return 1
        fi
    else
        writeLog "checkDrsvalue()| INFO:The drs_rules_num_limit is not 20,Skip to change drs_rules_num_limit."
        return 0
    fi    
}
#处理FC8.0整机上下电导致的虚拟机漂移问题
function checkDetactionTime()
{
    cat /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/vrmconfig.properties |grep 'HA_CHECK_HOST_FAULT_DETACTION_TIME=false'>/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        writeLog "checkDetactionTime()| INFO:Begin to config vrmconfig.properties about the HA_CHECK_HOST_FAULT_DETACTION_TIME."
        sed -i 's/HA_CHECK_HOST_FAULT_DETACTION_TIME=false/HA_CHECK_HOST_FAULT_DETACTION_TIME=true/g' /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/vrmconfig.properties
        if [ $? -eq 0 ]
        then
            writeLog "checkDetactionTime()| INFO:Success to config vrmconfig.properties about the HA_CHECK_HOST_FAULT_DETACTION_TIME."
            return 0
        else
            writeLog "checkDetactionTime()| FATAL:Failed to config vrmconfig.properties about the HA_CHECK_HOST_FAULT_DETACTION_TIME."
            return 1
        fi
    else
        writeLog "checkDetactionTime()| INFO:Skip to config vrmconfig.properties about the HA_CHECK_HOST_FAULT_DETACTION_TIME."
        return 0
    fi
}

#FC8.0合入的新功能，虚拟机下电再上电优先原主机启动
function checkVMStartOnOriginalHost()
{
    cat /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/vrmconfig.properties |grep 'VM_START_ON_ORIGINAL_HOST=false' >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        writeLog "checkDetactionTime()| INFO:Begin to config vrmconfig.properties about the VM_START_ON_ORIGINAL_HOST."
        sed -i 's/VM_START_ON_ORIGINAL_HOST=false/VM_START_ON_ORIGINAL_HOST=true/g' /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/classes/vrmconfig.properties
        if [ $? -eq 0 ]
        then
            writeLog "checkDetactionTime()| INFO:Success to config vrmconfig.properties about the VM_START_ON_ORIGINAL_HOST."
            return 0
        else
            writeLog "checkDetactionTime()| FATAL:Failed to config vrmconfig.properties about the VM_START_ON_ORIGINAL_HOST."
            return 1
        fi
    else
        writeLog "checkDetactionTime()| INFO:Skip to config vrmconfig.properties about the VM_START_ON_ORIGINAL_HOST."
        return 0
    fi
}

#FC8.0合入的新功能，数据存储达到95%后虚拟机挂起
function checkDatastoreCapacityUsageMonitor()
{
    cat /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/core-config.xml |grep 'dataStoreCapacityUsageMonitor' |grep 'off' >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        writeLog "checkDatastoreCapacityUsageMonitor()| INFO:Begin to config core-config.xml about the DatastoreCapacityUsageMonitor."
        sed -i 's#<property *name="dataStoreCapacityUsageMonitor" *.*/>#<property name="dataStoreCapacityUsageMonitor" value="on" />#g' /opt/galax/vrm/tomcat/webapps/ROOT/WEB-INF/core-config.xml
        if [ $? -eq 0 ]
        then
            writeLog "checkDatastoreCapacityUsageMonitor()| INFO:Success to config core-config.xml about the DatastoreCapacityUsageMonitor."
            return 0
        else
            writeLog "checkDatastoreCapacityUsageMonitor()| FATAL:Failed to config core-config.xml about the DatastoreCapacityUsageMonitor."
            return 1
        fi
    else
        writeLog "checkDetactionTime()| INFO:Skip to config core-config.xml about the DatastoreCapacityUsageMonitor."
        return 0
    fi
}

function main()
{
    initLog
    writeLog "main()| INFO:Begin to do post script."
    #判断用户
    userid=`id | awk -F "[()]" '{print $2}'`
    if [ "$userid" != "root" ] 
    then
        writeLog "main()| WARNING:the script must be run with root, exit."
        exit 1
    fi
    fcVerison=`cat /opt/galax/version/GalaxVersion.cfg` 
    writeLog "main()| INFO:the fcVerison is $fcVerison."
    uname -a |grep aarch64 >/dev/null 2>&1
    if [ $? -eq 0 ] 
    then
        fcArchitecture="ARM"
    else
        fcArchitecture="X86"
    fi
    writeLog "main()| INFO:the fcArchitecture is $fcArchitecture."
    
    if [ $fcArchitecture == "X86" ]
    then
        if [[ $fcVerison == 6.5* ]]
        then
            #step1
            checkVMStartOnOriginalHost
            step1=$?
            #step2
            checkDatastoreCapacityUsageMonitor
            step2=$?
            #step3
            checkPendingvalue
            step4=$?
            #step4
            checkDrsvalue
            step4=$?        
            if [ $step1 -ne 0 ]||[ $step2 -ne 0 ]||[ $step3 -ne 0 ]||[ $step4 -ne 0 ]
            then
                writeLog "main()| INFO:Failed to do post script, please check!"
                exit 1
            else
                writeLog "main()| INFO:restart the vrm service!"
                service vrmd restart
                if [ $? -eq 0 ]
                then 
                    writeLog "main()| INFO:bash script success!"
                fi
            fi
        else
            #step1
            checkDetactionTime
            step1=$?
            #step2
            checkVMStartOnOriginalHost
            step2=$?
            #step3
            checkDatastoreCapacityUsageMonitor
            step3=$?
            #step4
            checkDrsvalue
            step4=$?        
            if [ $step1 -ne 0 ]||[ $step2 -ne 0 ]||[ $step3 -ne 0 ]||[ $step4 -ne 0 ]
            then
                writeLog "main()| INFO:Failed to do post script, please check!"
                exit 1
            else
                writeLog "main()| INFO:restart the vrm service!"
                service vrmd restart
                if [ $? -eq 0 ]
                then 
                    writeLog "main()| INFO:bash script success!"
                fi
            fi            
        fi
    fi
    if [ $fcArchitecture == "ARM" ]
    then
        #step1
        checkVMStartOnOriginalHost
        step1=$?
        #step2
        checkDatastoreCapacityUsageMonitor
        step2=$?        
        if [ $step1 -ne 0 ]||[ $step2 -ne 0 ]
        then
            writeLog "main()| INFO:Failed to do post script, please check!"
            exit 1
        else
            writeLog "main()| INFO:restart the vrm service!"
            service vrmd restart
            if [ $? -eq 0 ]
            then 
                writeLog "main()| INFO:bash script success!"
            fi
        fi
    fi
}

main $@


