#!/bin/bash
export LC_ALL="en_US.UTF-8"
FileName="`basename $0`"
MODULE_NAME="`echo ${FileName} | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"

scena=$1

function clean_vgs()
{
    vgs=$(vgs | grep -v "VG" | awk '{ print $1}' | xargs )
    for vg in ${vgs}
    do
       [ ${vg} != "vg_root" ] && vgremove -y ${vg}
    done
}

function clean_pvs()
{
    pvs=$(pvs | grep -v "PV" | awk '{ print $1}' | xargs )
    for pv in ${pvs}
    do
        echo ${pv}|grep "da" &>/dev/null
        [ $? -ne 0 ] && pvremove -y ${pv}
    done
}

function clean_part()
{
    disks=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}'| xargs)
    disk_1=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "1p")
    for disk in ${disks}
    do
        [ ${disk} == ${disk_1} ] && continue
        number=$(parted /dev/${disk} p 2>/dev/null |grep -n "Number" |awk -F: '{print $1}')
        [ -z ${number} ] && continue
        let number++
        numbers=$(parted /dev/${disk} p 2>/dev/null |tail -n +${number} | sed '/^\s*$/d' | awk '{print $1}' | xargs)
        for part in ${numbers}
        do
            echo ${part} | grep "^[0-9]\+" &>/dev/null
            [ $? -eq 0 ] && parted -s /dev/${disk} rm ${part} 
        done
    done        
}


function extend_vg_root() {
    local disk_name disk_path start_point end_point left_space gigabit new_partition_num

    disk_name=$(lsblk -o NAME,TYPE | grep sd | grep disk | grep -v ^fd | awk '{print $1}' | head -1)
    disk_path=/dev/${disk_name}

    # 执行parted命令打印磁盘剩余的空间
    start_point=$(parted -s ${disk_path} unit b print free | grep -i "free" | tail -1 | awk '{print $1}' | tr -cd "[0-9]")
    end_point=$(parted -s ${disk_path} unit b print free | grep -i "free" | tail -1 | awk '{print $2}' | tr -cd "[0-9]")
    left_space=$(parted -s ${disk_path} unit b print free | grep -i "free" | tail -1 | awk '{print $3}' | tr -cd "[0-9]")
    gigabit=$((10**9))
    # 剩余空间不足1G时跳过扩容
    if [ "${left_space}" -le "${gigabit}" ]; then
        echo "If the remaining space is less than 1 GB, skip the expansion step."
        return 0
    fi

    parted -s ${disk_path} unit b mkpart primary ext4 ${start_point} ${end_point}
    if [ $? -ne 0 ]; then
        echo "Failed to extend the vg_root volume group."
        return 1
    fi

    new_partition_num=$(parted -s ${disk_path} print | grep "primary" | tail -1 | awk '{print $1}')
    if [ -z "${new_partition_num}" ]; then
        echo "Check new partition number failed."
        return 1
    fi
    pvcreate "${disk_path}${new_partition_num}" || { echo "Failed to create new pv."; return 1; }
    vgextend vg_root "${disk_path}${new_partition_num}" || { echo "Failed to vgextend the vg_root."; return 1; }
}

function makelvm_uefi()
{
    diskcount=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | wc -l)
    disk_1=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "1p")
    systemd-detect-virt | grep -i "none" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        if [ ${diskcount} -eq 1 -o ${diskcount} -eq 2 ]
        then
            lvcreate -y -l 100%VG -n opt vg_root
            mkfs.ext4 /dev/mapper/vg_root-opt
            [ ! -d /opt ] && mkdir -p /opt
            mount /dev/mapper/vg_root-opt /opt
            grep "^/dev/mapper/vg_root-opt" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_root-opt /opt ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_root-opt to /opt successfully."
        elif [ ${diskcount} -eq 3 -o ${diskcount} -eq 4 -o ${diskcount} -ge 5 ]
        then
            extend_vg_root || return 1
            disk_2=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "2p")
            disk_3=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "3p")
            parted -s /dev/${disk_2} mklabel gpt
            parted -s /dev/${disk_2} mkpart primary 1 100%
            partprobe
            pvdb_1="${disk_2}1"
            pvcreate -f /dev/${pvdb_1}
            vgextend vg_root /dev/${pvdb_1}
            # 若vg_root剩余空间大于100G，则预留100G空间
            left_space=$(vgs --units G | grep -w "vg_root" | awk '{print $7}' | sed "s/G//")
            if [ $(echo "${left_space} > 100" | bc) -eq 1 ]; then
                lvcreate -y -L 100G -n spare vg_root
            fi
            lvcreate -y -l 100%VG -n opt vg_root

            mkfs.ext4 /dev/mapper/vg_root-opt
            [ ! -d /opt ] && mkdir -p /opt
            mount /dev/mapper/vg_root-opt /opt
            grep "^/dev/mapper/vg_root-opt" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_root-opt /opt ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_root-opt to /opt successfully."

            # Manager + Analyzer, skip disk_3 and disk_4
            if [ "x${scena}" == "xmanager_share_analyzer" ]
            then
                echo "Manager_Analyzer skip disk_3 and disk_4."
                echo "Manager_Analyzer skip disk_3 and disk_4." > /tmp/lvm.log
                return 0
            fi

            parted -s /dev/${disk_3} mklabel gpt
            parted -s /dev/${disk_3} mkpart primary 1 100%
            partprobe
            pvdc_1="${disk_3}1"
            pvcreate -f /dev/${pvdc_1}
            vgcreate vg_sdc /dev/${pvdc_1}
            lvcreate -y -l 100%VG -n systembackup vg_sdc
            mkfs.ext4 /dev/mapper/vg_sdc-systembackup
            [ ! -d /opt/systembackup ] && mkdir -p /opt/systembackup
            mount /dev/mapper/vg_sdc-systembackup /opt/systembackup
            grep "^/dev/mapper/vg_sdc-systembackup" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdc-systembackup /opt/systembackup ext4 defaults 1 2" >> /etc/fstab     
            echo "mount /dev/mapper/vg_sdc-systembackup to /opt/systembackup successfully."
            disk_4=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "4p")
            if [ -n "${disk_4}" ]
            then
                parted -s /dev/${disk_4} mklabel gpt
                parted -s /dev/${disk_4} mkpart primary 1 100%
                partprobe
                pvdd_1="${disk_4}1"
                pvcreate -f /dev/${pvdd_1}
                vgcreate vg_sdd /dev/${pvdd_1}
                lvcreate -y -l 100%VG -n databackup vg_sdd
                mkfs.ext4 /dev/mapper/vg_sdd-databackup
                [ ! -d /opt/databackup ] && mkdir -p /opt/databackup
                mount /dev/mapper/vg_sdd-databackup /opt/databackup
                grep "^/dev/mapper/vg_sdd-databackup" /etc/fstab &>/dev/null
                [ $? -ne 0 ] && echo "/dev/mapper/vg_sdd-databackup /opt/databackup ext4 defaults 1 2" >> /etc/fstab
                echo "mount /dev/mapper/vg_sdd-databackup to /opt/databackup successfully."
            fi
        else
            echo "Error:The number of disk groups is not supported,exit!"
            exit 1
        fi
    fi
}


function makelvm_bios()
{
    diskcount=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | wc -l)
    disk_1=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "1p")
    systemd-detect-virt | grep -i "none" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        if [ ${diskcount} -eq 1 -o ${diskcount} -eq 2 ]
        then
            lvcreate -y -l 100%VG -n opt vg_root
            mkfs.ext4 /dev/mapper/vg_root-opt
            [ ! -d /opt ] && mkdir -p /opt
            mount /dev/mapper/vg_root-opt /opt
            grep "^/dev/mapper/vg_root-opt" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_root-opt /opt ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_root-opt to /opt successfully."
        elif [ ${diskcount} -eq 3 -o ${diskcount} -eq 4 -o ${diskcount} -ge 5 ]
        then
            extend_vg_root || return 1
            disk_2=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "2p")
            disk_3=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "3p")
            /sbin/fdisk /dev/${disk_2}  <<EOF
n
p
1


t

8e
w
EOF
            partprobe
            pvdb_1="${disk_2}1"
            pvcreate -f /dev/${pvdb_1}
            vgextend vg_root /dev/${pvdb_1}
            # 若vg_root剩余空间大于100G，则预留100G空间
            left_space=$(vgs --units G | grep -w "vg_root" | awk '{print $7}' | sed "s/G//")
            if [ $(echo "${left_space} > 100" | bc) -eq 1 ]; then
                lvcreate -y -L 100G -n spare vg_root
            fi
            lvcreate -y -l 100%VG -n opt vg_root

            mkfs.ext4 /dev/mapper/vg_root-opt
            [ ! -d /opt ] && mkdir -p /opt
            mount /dev/mapper/vg_root-opt /opt
            grep "^/dev/mapper/vg_root-opt" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_root-opt /opt ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_root-opt to /opt successfully."

            # Manager + Analyzer, skip disk_3 and disk_4
            if [ "x${scena}" == "xmanager_share_analyzer" ]
            then
                echo "Manager_Analyzer skip disk_3 and disk_4."
                echo "Manager_Analyzer skip disk_3 and disk_4." > /tmp/lvm.log
                return 0
            fi

            /sbin/fdisk /dev/${disk_3}  <<EOF
n
p
1


t

8e
w
EOF
            partprobe
            pvdc_1="${disk_3}1"
            pvcreate -f /dev/${pvdc_1}
            vgcreate vg_sdc /dev/${pvdc_1}
            lvcreate -y -l 100%VG -n systembackup vg_sdc
            mkfs.ext4 /dev/mapper/vg_sdc-systembackup
            [ ! -d /opt/systembackup ] && mkdir -p /opt/systembackup
            mount /dev/mapper/vg_sdc-systembackup /opt/systembackup
            grep "^/dev/mapper/vg_sdc-systembackup" /etc/fstab &>/dev/null
            [ $? -ne 0 ] && echo "/dev/mapper/vg_sdc-systembackup /opt/systembackup ext4 defaults 1 2" >> /etc/fstab
            echo "mount /dev/mapper/vg_sdc-systembackup to /opt/systembackup successfully."
            disk_4=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | sed -n "4p")
            if [ -n "${disk_4}" ]
            then
                /sbin/fdisk /dev/${disk_4}  <<EOF
n
p
1


t

8e
w
EOF
                partprobe
                pvdd_1="${disk_4}1"
                pvcreate -f /dev/${pvdd_1}
                vgcreate vg_sdd /dev/${pvdd_1}
                lvcreate -y -l 100%VG -n databackup vg_sdd
                mkfs.ext4 /dev/mapper/vg_sdd-databackup
                [ ! -d /opt/databackup ] && mkdir -p /opt/databackup
                mount /dev/mapper/vg_sdd-databackup /opt/databackup
                grep "^/dev/mapper/vg_sdd-databackup" /etc/fstab &>/dev/null
                [ $? -ne 0 ] && echo "/dev/mapper/vg_sdd-databackup /opt/databackup ext4 defaults 1 2" >> /etc/fstab
                echo "mount /dev/mapper/vg_sdd-databackup to /opt/databackup successfully."
            fi
        else
            echo "Error:The number of disk groups is not supported,exit!"
            exit 1
        fi
    fi
}


function makelvm()
{
    # 若opt分区已存在，则跳过划分区步骤
    [ -L /dev/vg_root/opt ] && return 0
    clean_vgs
    clean_pvs
    clean_part
    lsblk | grep "/boot/efi$" &>/dev/null
    if [ $? -eq 0 ]
    then
        makelvm_uefi
    else
        makelvm_bios
    fi
}
makelvm $@
RET_MAIN=$?
if [[ "${RET_MAIN}" == "0" ]]
then
    logger -t $USER -p local0.info "$FileName;Successful;${OPERIP:-127.0.0.1};Excute execution $FileName."
else
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Excute execution $FileName."
fi
exit ${RET_MAIN}
