#!/bin/bash

LC_ALL=en_US
export LC_ALL

expect<<EOF
set timeout 60
spawn fdisk /dev/sdb
expect "*help):"
send "n\r"
expect "*primary*"
send "p\r"
expect {
    "*Partition number*" { send "\r"; exp_continue }
    "*First sector*" { send "\r" }
}
expect "*Last sector*"
send "\r"
expect "*help*"
send "t\r"
expect "*type*"
send "8e\r"
expect "*help*"
send "w\r"
expect eof
EOF

partprobe

vgextend vg_root /dev/sdb1

sleep 1s

check_opt_vg=`df -h|grep opt`
if [ -z "$check_opt_vg" ];then
    lvcreate -y -L 20G -n opt vg_root 
    mkfs -t ext4 /dev/vg_root/opt
    mount /dev/vg_root/opt /opt
    cat "/dev/mapper/vg_root-opt /opt ext4 defaults,iversion 1 2" >>/etc/fstab
fi

lvextend -l +100%FREE  /dev/mapper/vg_root-opt
resize2fs /dev/mapper/vg_root-opt
lvdisplay /dev/vg_root/opt

