#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalDate.sh
# Version:Data          : 
# Description           : set date time
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"
    
#get absolute path 
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
#import common variable..
. ../common/error_code.inc
. ../common/common.inc
cd - >/dev/null 2>&1
# set time cmd
SET_CMD=""


# Name        : fn_get_config
# Description : get the config from osmu
# Parameters  : $1 the absoluately path of config file 
# Parameter   : $2 the index of host
# Parameter   : $3 get slot number
# Parameter   : $4 get smm card ip
function fn_get_config()
{
    
    local TMP_CONFIG_FILE=$1 
   
    local TIME_DATE
    local TMP_CONTENT_FLAG
    local TMP_TIME
    local TMP_DATE
    
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.." > /dev/null 2>&1
    
    TIME_DATE=`fn_get_value "${TMP_CONFIG_FILE}" "TIME_DATE"`
    if [ -z "${TIME_DATE}" ]
    then
        PRINT_LOG "WARN" "The param TIME_DATE<${TIME_DATE}> could not be found!" 
        return 1;
    fi 

    TMP_CONTENT_FLAG=`echo "${TIME_DATE//-/\/}" | egrep "^[0-9]{4}(/[0-9]{2}){2} [0-9]{2}(:[0-9]{2}){2}\>"` 
    if [ -z "${TMP_CONTENT_FLAG}" ]
    then
        PRINT_LOG "WARN" "The param TIME_DATE<${TIME_DATE}> should be the format like this <YYYY/MM/DD hh:mm:ss>!" 
        return 1;
    fi 
    
    TMP_DATE=`echo "${TIME_DATE//-/\/}" | awk 'BEGIN {FS=" "}{print $1}'`
    TMP_TIME=`echo "${TIME_DATE}" | awk 'BEGIN {FS=" "}{print $2}'`
    TMP_DATE=`echo "${TMP_DATE}" | awk 'BEGIN {FS="/"}{print $2"/"$3"/"$1}'`
    TIME_DATE="${TMP_DATE} ${TMP_TIME}"
    
    IFS_TMP=$IFS
    IFS=' '
    TIME_DATE=($TIME_DATE)
    IFS=$IFS_TMP
    
    eval $2="(${TIME_DATE[@]})"
        
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.. OK!!!" > /dev/null 2>&1
    return 0;
}


# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value
function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi
    
    if [ "${RETCODE}" = 0 ]
    then
        echo "`date` `hostname` `whoami` setLocalDate.sh;Successful;Set Date and Time Successfully." >> /var/log/localmessages
        echo "Set Date Successfully. "
    else
        echo "`date` `hostname` `whoami` setLocalDate.sh;Failed;Set Date and Time System Failed." >> /var/log/localmessages
        echo "Set Date Failed."
    fi    
    chmod 640 /var/log/localmessages
    
    return 0;
}

 
# Name        : fn_set_hardware_clock
# Description : set hardware clock
# Parameters  : the absoluately path of config file 
function fn_set_hardware_clock()
{

    local TMP_CONTENT_FILE=$1
    
    local CONST_DIFF_SECONDS=10
    local CURRENT_SYS_TIME
    local CURRENT_HC_TIME
    local COUNT=1
    
    export LC_TIME="POSIX"
    
    while [ "${COUNT}" -le 3 ]
    do 
        PRINT_LOG "INFO" "Try ${COUNT} times to set hardware clock..."
        local os_version_file_old="/etc/SuSE-release"
        local os_version_file_new="/etc/os-release"
        local suse_version="11"
        local euler_standard="EulerOS"
        if [ -f "${os_version_file_new}" ]
        then
            PRINT_LOG "INFO" "Get os version from file ${os_version_file_new}"
            suse_version=$( cat ${os_version_file_new} | grep "^VERSION=" | awk -F"=" '{print $2}' | sed "s/^\"//g" | sed "s/\"$//g" | awk -F"-" '{print $1}' )
            euler_version=$( cat ${os_version_file_new} | grep "^NAME=" | awk -F"=" '{print $2}' | sed "s/^\"//g" | sed "s/\"$//g" )
        elif [ -f "${os_version_file_old}" ]
        then
            PRINT_LOG "INFO" "Get os version from file ${os_version_file_old}"
            suse_version=$( cat ${os_version_file_old} | grep "^VERSION" | awk -F"=" '{print $2}' | xargs ) 
        else
            PRINT_LOG "FATAL" "Can not get os version."
            return 1
        fi
        PRINT_LOG "INFO" "Current os version:${suse_version}"
        
        if [ "${suse_version}" == "11" ]
        then
            /etc/init.d/boot.clock stop > "${TMP_CONTENT_FILE}" 2>&1 
            PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        elif [ "${suse_version}" == "12" ] || [ "X${euler_version}" = "X${euler_standard}" ]
        then
            hwclock --systohc --localtime > "${TMP_CONTENT_FILE}" 2>&1 
            sleep 5
            PRINT_LOG "INFO" "set local rtc 0"
            timedatectl set-local-rtc 0 > "${TMP_CONTENT_FILE}" 2>&1 
            grep "UTC" /etc/adjtime 2>&1 
            if [[ $? == 0 ]]
            then
                PRINT_LOG "INFO" "set local rtc 0 success"
            else
                sleep 2
                timedatectl set-local-rtc 0 2>&1
                PRINT_LOG "INFO" "set local rtc 0 again"
            fi
            sleep 2
            PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" 
        else
            PRINT_LOG "FATAL" "Can not get os version."
            return 1
        fi

        PRINT_LOG "INFO" "The file system current time is: `date`"
        CURRENT_TIME=`date --date="$(date --rfc-3339=s)" '+%s'`
        CURRENT_HC_TIME=`hwclock`
        PRINT_LOG "INFO" "The hardware current clock is: ${CURRENT_HC_TIME}"

        CURRENT_HC_TIME=`date --date="$(hwclock)" '+%s'`
        let DIFF_SECONDS="${CURRENT_TIME}"-"${CURRENT_HC_TIME}"
        DIFF_SECONDS=`echo ${DIFF_SECONDS} | sed 's/^-//g'`
        PRINT_LOG "INFO" "The time difference: ${DIFF_SECONDS}"

        if [ "${DIFF_SECONDS}" -lt "${CONST_DIFF_SECONDS}" ]
        then 
            PRINT_LOG "INFO" "System time sync to hardware clock success."
            return 0
        fi

        let COUNT++
    done

    PRINT_LOG "WARN" "System time sync to hardware clock failure!!!"
    return 0

}

 
# Name        : fn_set_date_time
# Description : set date time
function fn_set_date_time()
{
    local TIME_DATE=$1
 
    PRINT_LOG "INFO" "Setting date time.."
    #Setting OSMU system time .
    ${SET_CMD} "${TIME_DATE}" > "${TMP_CONTENT_FILE}" 2>&1
    if [ $? != 0 ]
    then
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        PRINT_LOG "WARN" "Exec<date -s \"${TIME_DATE}\"> failure!!!"
        return 1;
    fi

    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
    PRINT_LOG "INFO" "Exec<date -s \"${TIME_DATE}\"> OK!!!"
    PRINT_LOG "INFO" "Setting date time.. OK!!!"
    
}


function fn_main() 
{
    local REF_TIME_DATE

    PRINT_LOG "INFO" "bash $0 $*"
    if [ $# -lt 1 ]
    then
        PRINT_LOG "WARN" "Usage: $0 <config file>"
        PRINT_LOG "WARN" "e.g:      $0 /opt/osmu/script/properties/sample.properties"
        fn_check_status "${ERROR_PARAM}"
    fi
    
    fn_title "Setting date .."
    # ݴǷntpǷΪⲿʱԴʱ䣬ȷִеǷ-u
    if [ -n "$3" ] && [ "$3" == "from_ntp" ];then
        SET_CMD="date -s"
    else
        SET_CMD="date -u -s"
    fi

    REF_TIME_DATE=($1 $2)

    fn_set_date_time "${REF_TIME_DATE[*]}"
    fn_check_status "$?" "fn_set_date_time"

    fn_set_hardware_clock "${TMP_CONTENT_FILE}"
    fn_check_status "$?" "fn_set_hardware_clock"    

    return 0;
}

fn_main $@
RET=$?
fn_write_operation_log ${RET}
FUNC_CLEAN_TMP_FILE
exit ${RET}


