@rem Copyright Huawei Technologies Co., Ltd. 2010-2020. All rights reserved.
@rem Description: the file to start EasySuite package
@echo off

cd /d %~dp0

:begin
    set HOST=localhost
    set PORT=19090
    set SEE_MASK_NOZONECHECKS=1
    set EASYSUITEPATH=%~dp0\easysuite
    set EASYSUITESYSTEMPATH=C:\Windows\System32\wbem
    set PATH=%EASYSUITEPATH%\3rdparty\Python39;%EASYSUITEPATH%\3rdparty\Python39\Lib;%EASYSUITESYSTEMPATH%;%PATH%
    set PYTHONPATH=%EASYSUITEPATH%;%EASYSUITEPATH%\3rdparty\Python39\Lib
    set PYTHONHOME=%EASYSUITEPATH%\3rdparty\Python39
    set PYTHONUSERBASE=%EASYSUITEPATH%\3rdparty\Python39
    
    rem checkEnv
    goto checkEnv
    
    exit

:getLength

    set /a num+=1
    set CURRENTPATH=%CURRENTPATH:~0,-1%
    if defined CURRENTPATH goto :getLength
    if %num% GTR 80 (
        echo The current path is too long, more than 80 characters!
        pause 
        exit
    )
    
    netstat -ano|findstr %PORT%|findstr LISTENING >nul 2>&1
    set result=%ERRORLEVEL%
    if %result%==0 (
        echo Port %PORT% is already occupied, you can execute ^"stop.bat^" release!
        pause
        exit
    ) else (
        goto loadMigrateSolution
    )

:loadMigrateSolution
    echo Start loading MigrateSolution, it may cost about 5 minutes, don't close this window before it auto close...
    dir %EASYSUITEPATH%\utils\migrate\load_migrate_solution\file_handling\load_migration_process.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\migrate\load_migrate_solution\file_handling\load_migration_process.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%'); from utils.migrate.load_migrate_solution.file_handling.load_migration_process import load_process; load_process()" >nul 2>&1
    )else (
        echo Start failed, the file %EASYSUITEPATH%\utils\migrate\load_migrate_solution\file_handling\load_migration_process.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==1 (
        echo The MigrateSolution does not exist and does not need to be loaded.
    )
    if %result%==2 (
        echo MigrateSolution signature file cms or crl does not exist.
        pause
    )
    if %result%==3 (
        echo Migrate solution name error.
        pause
    )
    if %result%==4 (
        echo MigrateSolution inner error.
        pause
        exit
    )
    if %result%==0 (
        echo Loading MigrateSolution succeeded.
    )
    goto pluginPrepare
    
:checkEnv
    set flag=False
    wmic os get caption | findstr 11 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 10 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 8 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 2012 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 2016 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 2008 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=False
    )
    if %flag%==False (
        echo The current operating system is not supported, only support Windows 8/10/11 and Windows Server 2012/2016 system!
        pause
        exit
    )

    dir %EASYSUITEPATH% >nul 2>&1
    if %ERRORLEVEL% NEQ 0 (    
        echo Start failed, the path is too long, or the path may contain spaces or invalid characters, please check!
        pause
        exit
    )
    dir %EASYSUITEPATH%\utils\start_param_check.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\start_param_check.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%\utils'); import start_param_check; start_param_check.start_param_check()" >nul 2>&1
    ) else (
        echo Start failed, the file easysuite\utils\start_param_check.py^(c^) does not exist, or the current path is too long!
        pause 
        exit
    )
    
    set result=%ERRORLEVEL%
    if %result%==1 (
        echo The current path is not supported, please confirm the path only consists of letters, numbers, underlined!
        pause 
        exit
    )
    if %result%==3 (
        echo The current hostname is not supported, the hostname not support chinese characters!
        pause 
        exit
    )
    rem if system language is not supported, exit and print the error reason
    if %result%==4 (
        echo The System Language is not supported, only simplified Chinese and English supported.!
        pause 
        exit
    )
    
    set CURRENTPATH=%~dp0
    set num=0
    set "CURRENTPATH=%CURRENTPATH:\=%"
    
    goto getLength

:pluginPrepare
    echo Start loading ESSolution package, it will cost about 5 minutes, don't close this window before it auto close...
    dir %EASYSUITEPATH%\utils\start_plugin_prepare.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\start_plugin_prepare.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%\utils');sys.path.append(r'%EASYSUITEPATH%'); import start_plugin_prepare; start_plugin_prepare.start_plugin_prepare()" >nul 2>&1
    )else (
        echo Start failed, the file %EASYSUITEPATH%\utils\start_plugin_prepare.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==2 (
        echo Unzip Solution or Migrate zipfile failed, please check whether the zipfile is damaged or the current path is too long.
        pause
        exit
    )
    if %result%==3 (
        echo Copy template files to '/easysuite/plugin/' failed, because the current path is too long.
        pause
        exit
    )
    if %result%==11 (
        echo Copy template files to '/var/software/escompontent/software' failed, because the current path is too long.
        pause
        exit
    )
    if %result%==5 (
        echo ESSolution or ESMigrate install package signature check failed.
        pause
        exit
    )
    if %result%==6 (
        echo Make path '/var/software/Solution' or '/var/software/Migrate' failed.
        pause
        exit
    )
    if %result%==8 (
        echo ESSolution or ESMigrate signature file cms or crl does not exist.
        pause
        exit
    )
    if %result%==9 (
        echo More than one ESSolution exists in the current path. Please remove the extra software packages and try again.
        pause
        exit
    )
    if %result%==10 (
        echo No matching ESSolution package is available and does not need to be loaded.
    )
    if %result%==0 (
        echo Loading ESSolution product_apps success.
    )
    goto setDBAuth

:setDBAuth  
    set DBPATH=%~dp0\easysuite\db
    
    if exist %DBPATH%\authenticate.flag (
        echo "authenticate.flag exist already, nothing need change. %date% %time%" >> %DBPATH%\authenticate.flag
        goto startServer
    )
    
    %EASYSUITEPATH%\3rdparty\Python39\python.exe -m easysuite.replace_key true
    if %errorlevel%==0 (
        echo The key is successfully replaced.
    ) else (
        echo Failed to replace the key.
        pause 
        exit
    )
    echo "Start delete Authenticated Users Group rights at %date% %time%" > %DBPATH%\authenticate.flag
    set str_a=false
    setlocal enabledelayedexpansion
    FOR /F "DELIMS=" %%i in ('ICACLS %DBPATH%') do (
        echo %%i | find "Authenticated Users">nul &&set str_a=true||set str_a=false
        if "!str_a!"  == "true" (
            ICACLS %DBPATH% /inheritance:d >nul 2>&1
            ICACLS %DBPATH% /remove:g "Authenticated Users" >nul 2>&1
            ICACLS %DBPATH% /grant:r "%USERDOMAIN%\%USERNAME%:(OI)(CI)F" >nul 2>&1
            echo "Delete Authenticated Users Group rights at %date% %time%"  >> %DBPATH%\authenticate.flag
        )
    )
    
    goto startServer
    
rem start server
:startServer
    if exist %EASYSUITEPATH%\manage.py (
        goto createCertificate
    ) else if exist %EASYSUITEPATH%\manage.pyc (
        goto createCertificate
    ) else (
        echo Start failed, the file %EASYSUITEPATH%\manage.py^(c^) does not exist!
        pause 
        exit
    )

rem run sslserver
:runSslserver
    set hour=%time:~,2%
    if "%time:~,1%"==" " set hour=0%time:~1,1%
    set /a ini_time=(%time:~0,2%)*3600+(1%time:~3,2%)*60+(1%time:~6,2%) >nul 2>&1
    start /b %EASYSUITEPATH%\runsslserver.bat >nul 2>&1
    echo Starting, please wait...
    goto listenServer
    

rem Generating self-signed certificate
:createCertificate
    echo Start generating self-signed certificate.
    dir %EASYSUITEPATH%\utils\create_certificate.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\create_certificate.pyc >nul 2>&1
    
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%\utils'); sys.path.append(r'%EASYSUITEPATH%'); import create_certificate; create_certificate.create_certificate()" >nul 2>&1
    )else (
        echo Start failed, the file %EASYSUITEPATH%\utils\create_certificate.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==1 (
        echo Failed to generate the self-signed certificate.
        pause
        exit
    )
    echo Generated from signature certificate succeeded.
    goto runSslserver

rem listen server
:listenServer
    netstat -ano|findstr %PORT%|findstr LISTENING >nul 2>&1
    set result=%ERRORLEVEL%
    if %result%==0 (
        echo Start the server successfully!
        eventcreate /T INFORMATION /L APPLICATION /ID 100 /D "start EasySuite successfully." >nul 2>&1
        echo [%date:~0,4%-%date:~5,2%-%date:~8,2% %hour%:%time:~3,2%:%time:~6,2%]start easysuite >> ./var/run/log/easysuite.log >nul 2>&1
        goto startBrowser
    ) else (
        goto isServerTimeout
    )

rem check server timeout
:isServerTimeout
    ping -n 1 127.1 >nul 2>&1
    set /a end_time=(%time:~0,2%)*3600+(1%time:~3,2%)*60+(1%time:~6,2%) >nul 2>&1
    set /a internal=%end_time%-%ini_time% >nul 2>&1
    
    if %internal% GEQ 60 (
        echo Failed to start the server!
        eventcreate /T ERROR /L APPLICATION /ID 100 /D "start EasySuite failed." >nul 2>&1
        pause 
        exit
    ) else (
        goto listenServer 
    )
    
:startBrowser
    echo %HOST%| findstr : >nul && (
        set HOST=[%HOST%]
    )
    dir %EASYSUITEPATH%\utils\search_browser.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\search_browser.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%\utils'); import search_browser; search_browser.search_browser()" >nul 2>&1
    ) else (
        echo Start failed, the file %EASYSUITEPATH%\utils\search_browser.py^(c^) does not exist!
        pause 
        exit
    )

    set result=%ERRORLEVEL%
    if %result%==11 (
        start /b chrome.exe "https://%HOST%:%PORT%"
    ) else if %result%==12 (
        start /b firefox.exe "https://%HOST%:%PORT%"
    ) else if %result%==13 (
        start /b msedge.exe "https://%HOST%:%PORT%"
    ) else (
        echo Please check whether the browser chrome 81+/firefox 75+/microsoft-edge 81+/Firefox ESR 78+ is installed correctly, If the browser cannot be displayed, please visit https://%HOST%:%PORT% using chrome 81+/firefox 75+/microsoft-edge  81+/Firefox ESR 78+.
        goto zip_process
        pause
    )
    goto zip_process

:zip_process
    echo Start zip software package.waiting...
    dir %EASYSUITEPATH%\utils\zip_process.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\zip_process.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%\utils'); sys.path.append(r'%EASYSUITEPATH%'); import zip_process; zip_process.zip_process()" >nul 2>&1
    )else (
        echo zip failed, the file %EASYSUITEPATH%\utils\zip_process.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==2 (
        echo Unzip Solution or Migrate zipfile failed, please check whether the zipfile is damaged or the current path is too long.
        pause
        exit
    )
    if %result%==3 (
        echo Copy template files to '/var/software/escompontent/software' failed, because the current path is too long.
        pause
        exit
    )
    if %result%==4 (
        echo Zip '*DeployTemplate.zip' or '*Expansion.zip' or 'Migrate.zip' failed.
        pause
        exit
    )
    if %result%==1 (
        echo Zip software package failed.
        pause
        exit
    )
    if %result%==0 (
        echo Zip software package succeeded.
    )