#!/bin/bash
. /etc/profile
#install dir
if [ "$#" = "2" -a "$1" = "-path" ]
then
    installDir=$2
else
    installDir=/opt/install
fi

#check root user
CheckUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}

#log
OperateLog()
{
    if [ -f "/opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh" ]
    then
        bash /opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh "$1" "$2"
        return
    fi
}

#installUniep
add_product()
{  
    #=======================set product===================================
    sleep 60
    su - ossadm -c "cd /opt/oss/manager/tools/resmgr && bash setproductinfo.sh -product $installDir/product_NCE.json -nodes $installDir/nodes_NCE.json -networkinfo $installDir/networkinfo_NCE.json"
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to install applications, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    if [ -f "/opt/oss/manager/adapter/postaddnode.sh" ];then
        su - ossadm -c "bash /opt/oss/manager/adapter/postaddnode.sh"
    fi
    return 0
}

Main()
{
    CheckUser
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to check the logged-in user, rendering the install_uniep.sh script failed." "error"
        return 1
    fi

    #add_product
    add_product
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to init the software package, rendering the add_product.sh script failed." "error"
        return 1
    fi
    sleep 60
    return 0
}

Main $*
exit $?