#!/usr/bin/env bash

pass="$1"
username="$2"

#检查密码规则
chackpass()
{ 
    local _pass="$1"
    local _uname="$2"
    local _passlen=${#_pass}
    if [ $_passlen -eq 0 ]
    then 
        echo "The length is equal to zero."
        return 1
    fi
    if [ $_passlen -lt 8 -o $_passlen -gt 64 ]
    then
        echo "The password must contain 8 to 64 characters."
        return 1 
    fi
    if ! echo "$_pass" | egrep "[[:upper:]]" &> /dev/null
    then
        echo "No capital letters."
        return 1
    fi
    if ! echo "$_pass" | egrep "[[:lower:]]" &> /dev/null
    then
        echo "No lowercase letters."
        return 1
    fi
    if   echo "$_pass" | egrep "[[:space:]]" &> /dev/null
    then
        echo "Can not contain spaces."
        return 1
    fi
    if ! echo "$_pass" | egrep '[0-9]' &> /dev/null
    then
        echo "No numbers."
        return 1
    fi
    echo "${_pass}"| egrep '[~\^#@*-+_.}{?:/\[%=]' > /dev/null 2>&1
    res1=$?
    echo "$_pass" | egrep ']' >/dev/null
    res2=$?
    if [ $res1 -ne 0  -a  $res2 -ne 0 ];then
        echo "No special characters."
        return 1
    fi
    echo "${_pass}" | egrep '[()|<>&`!$\";,]' >> /dev/null 2>&1
    res1=$?
    echo "$_pass" | egrep "[' ]" > /dev/null
    res2=$?
    if [ $res1 -eq 0 -o $res2 -eq 0 ];then
        echo ""  '()|<>&`!$\"'  "; and space are not allowed."    
        return 1
    fi
    res=0
    upper_pass=`echo $_pass | tr '[:lower:]' '[:upper:]'`
    upper_name=`echo $_uname | tr '[:lower:]' '[:upper:]'`
    rev_upper_name=`echo $upper_name | rev`
    if [ $upper_pass = $upper_name -o $upper_pass = $rev_upper_name ];then
        res=1
    fi
    if [[ $upper_pass =~ $upper_name ]];then
        res=1
    fi
    if [ $res -eq 1 ];then
        echo "The password cannot be any user name or user name in reverse order."
        return 1
    fi
    
    passCharList=`echo $_pass | sed 's/[^\n]/&\n/g'`
    reg=""
    count=1
    for char in ${passCharList};do
        if [ "${char}" == "${reg}" ];then
            count=`expr ${count} + 1`
        else
            count=1
        fi
        reg=${char}
        
        if [ ${count} -gt 2 ];then
            echo "The password cannot contain more than two consecutive identical characters."
            return 1
        fi
    done
    return 0
}

chackpass "${pass}" "${username}"
if [ $? == 0 ];then
    echo ${username}:${pass} | chpasswd >/dev/null
    exit $?
else
    exit 1
fi
