#!/bin/bash
installDir=$1
uniepPkg_path=$2
cryptDir=$installDir/crypt

. $installDir/read_pw.sh


make_cipher()
{
    mkdir -p ${cryptDir}/cipher
    cd ${cryptDir}/cipher
    cp -rf "${uniepPkg_path}"/Custom/cloudsop_cipher.zip ${cryptDir}/cipher
    unzip -oq cloudsop_cipher.zip -d "${cryptDir}"/cipher
    touch cloudsop_cipher_mode.flag
}

make_python_lib()
{
    mkdir -p ${cryptDir}/lib
    mkdir -p ${cryptDir}/temp
    cp -rf ${uniepPkg_path}/MCTools-*.zip ${cryptDir}/temp
    unzip -oq ${cryptDir}/temp/MCTools-*.zip -d ${cryptDir}/temp
    unzip -oq ${cryptDir}/temp/Rtsp/common/mccommon/mccommon*.zip -d ${cryptDir}/temp
    cp -rf ${cryptDir}/temp/tools/pyscript/* ${cryptDir}/lib
    rm -rf ${cryptDir}/temp/*
}

make_runtime()
{
    mkdir -p ${cryptDir}/python
    cp -rf ${uniepPkg_path}/CloudBase-*.zip ${cryptDir}/temp
    unzip -oq ${cryptDir}/temp/CloudBase-*.zip -d ${cryptDir}/temp
    cp -rf ${cryptDir}/temp/Rtsp/python/python-*.zip ${cryptDir}/temp
    unzip -oq ${cryptDir}/temp/python-*.zip -d ${cryptDir}/python
}

make_script()
{
    mkdir -p ${cryptDir}/script
    cp -rf ${installDir}/create_pwfile.py* ${cryptDir}/script
}


make_tools()
{
    mkdir -p $cryptDir
    make_cipher
    make_python_lib
    make_runtime
    make_script
}

export_env()
{
    export PYTHONPATH=${cryptDir}/lib
    export CIPHER_ROOT=${cryptDir}/cipher
    export IPMC_ROOT=${cryptDir}/cipher
}

# 读取密码
get_install_pw

# 生成工具
make_tools

# 导出环境变量
export_env

# 生成文件
(echo $all_os_default_passwd; echo $product_pwd_sopuser; echo $product_pwd_ossadm; echo $product_pwd_ossuser; echo $product_pwd_redis_dbuser; echo $product_pwd_zenith_sys; echo $product_pwd_admin_web_control;) | ${cryptDir}/python/bin/python -c "import sys;sys.path.append('${cryptDir}/script'); import create_pwfile; create_pwfile.create_pwfile('$installDir')" >/dev/null 2>&1