function getLogPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        logPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        logPath="$(pwd)/${dir}"
    else
        logPath="${dir}"
    fi
    return 0
}

getLogPath

MODULE_NAME="$(basename $0)"
logFile="${logPath}/${MODULE_NAME}.log"

OperateLog()
{
    unset Level
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}


get_install_pw()
{
    #获取节点密码信息
    echo "es_input: all_os_default_passwd"
    read -r all_os_default_passwd
    if [ "X${all_os_default_passwd}" == "X" ];then
        OperateLog "error" "Error: get user passwd failed."
        exit 1
    fi
    
    echo "es_input: product_pwd_sopuser"
    read -r product_pwd_sopuser
    if [ "X${product_pwd_sopuser}" == "X" ];then
        OperateLog "error" "Error: get sopuser passwd failed."
        exit 1
    fi

    echo "es_input: product_pwd_ossadm"
    read -r product_pwd_ossadm
    if [ "X${product_pwd_ossadm}" == "X" ];then
        OperateLog "error" "Error: get ossadm passwd failed."
        exit 1
    fi
    
    echo "es_input: product_pwd_ossuser"
    read -r product_pwd_ossuser
    if [ "X${product_pwd_ossuser}" == "X" ];then
        OperateLog "error" "Error: get ossuser passwd failed."
        exit 1
    fi

    echo "es_input: product_pwd_redis_dbuser"
    read -r product_pwd_redis_dbuser
    if [ "X${product_pwd_redis_dbuser}" == "X" ];then
        OperateLog "error" "Error: get redis_dbuser passwd failed."
        exit 1
    fi

    echo "es_input: product_pwd_zenith_sys"
    read -r product_pwd_zenith_sys
    if [ "X${product_pwd_zenith_sys}" == "X" ];then
        OperateLog "error" "Error: get zenith_sys passwd failed."
        exit 1
    fi

    echo "es_input: product_pwd_admin_web_control"
    read -r product_pwd_admin_web_control
    if [ "X${product_pwd_admin_web_control}" == "X" ];then
        OperateLog "error" "Error: get admin_web_control passwd failed."
        exit 1
    fi
}
