'''
    常用函数
'''
from util.httpclient import CommonHttpClient
from util import common

import os
import json
import time
import logging
import subprocess

def get_ip(num):
    '''
    :param num: ip's id
    :return:
    '''
    _ip = ""
    file_name = "/opt/oss/manager/etc/sysconf/nodelists.json"
    if os.path.exists(file_name):
        with open(file_name, "rb") as node_f:
            node_info = json.load(node_f)
            if str(num) in node_info["nodeList"]:
                for dic in node_info["nodeList"][str(num)]["IPAddresses"]:
                    if "maintenance" in dic["usage"]:
                        _ip = dic["IP"]
    return _ip


def set_log(stream=False, filename=None, level=logging.INFO, name="default"):
    '''
    set log
    :param stream: 是否输出到屏幕
    :param filename: 是否输出到文件
    :param level: 日志级别
    :param name: 日志名称
    :return: logger
    '''
    fmt = logging.Formatter(
        '%(asctime)s– %(levelname)s–%(pathname)s–%(lineno)d: %(message)s')
    logger = logging.getLogger(name)
    logger.setLevel(level)
    if stream:
        sh_stream = logging.StreamHandler()
        sh_stream.setFormatter(fmt)
        logger.addHandler(sh_stream)
    if filename:
        sh_file = logging.FileHandler(filename, encoding="utf-8")
        sh_file.setFormatter(fmt)
        logger.addHandler(sh_file)
    return logger


def get_local_ip():
    '''
    获取本地ip地址
    :return: ip
    '''
    if hasattr(common, "getLocalIP"):
        return common.getLocalIP()
    else:
        return common.get_local_ip()


def get_ir_port():
    '''
    获取ir的端口号
    :return:
    '''
    if hasattr(common, "getIRAccessPort"):
        return common.getIRAccessPort()
    else:
        return common.get_ir_access_port()

def get_gmt_port():
    '''
    获取gmt ir的端口号
    :return:
    '''
    if hasattr(common, "getMgmtIRPort"):
        return common.getMgmtIRPort()
    else:
        return common.get_mgmt_ir_port()


def send_rest(_ip, port, url, mode, **params):
    '''
    调用平台res
    :param ip: ip地址
    :param port: 端口
    :param url: url
    :param mode: GET POST DELETE
    :params log, body, sleep, retry_times, content
    :return: 成功 0  失败 1
    '''
    http = CommonHttpClient(_ip, port, True, False)
    times = 0
    success = 0
    req_failed = 1
    body = params.get("body", None)
    while times <= params["retry_times"]:
        if mode == "GET":
            status, ret = http.get(url)
        elif mode == "POST":
            status, ret = http.post(url, body)
        elif mode == "DELETE":
            status, ret = http.delete(url, body)
        elif mode == "PUT":
            status, ret = http.put(url)
        if status == 200 or status == 204:
            result = success
            params["log"].info("%s [SUCCESS] %s %s response: %s, retry_times:%s,ip:%s,port:%s",
                               params["content"], mode, url, status, times,_ip,port)
            break
        else:
            params["log"].warn("%s [WARN] %s %s response: %s, retry_times:%s",
                                params["content"], mode, url, status, times)
            times += 1
            result = req_failed
            time.sleep(params["sleep"])
    return result, ret

def checkDCNServiceIR(num):
    '''
    调用DCNService的IR，确保服务可用
    :return: 成功 0  失败 1
    '''  
    log = set_log(stream=True)
    input_param = {"XX-Backend":"DCNService-"+str(num)+"-0"}
    _ip = get_local_ip()
    port = get_ir_port()
    url = "/rest/neutron/get-product-info"
    result, _ = send_rest(_ip, port, url, mode="GET", log=log,
                                sleep=6, retry_times=10000,
                                content="query flow table.")
    return result
    
def checkDCNOpenEMServiceIR(num):
    '''
    调用DCNOpenEMService南向服务的IR，确保服务可用
    :return: 成功 0  失败 1
    '''
    log = set_log(stream=True)
    input_param = {"XX-Backend":"DCNOpenEMService-"+str(num)+"-0"}
    _ip = get_local_ip()
    port = get_ir_port()
    url = "/rest/controller/dc/v3/jsonrpc/tls-query"
    result, _ = send_rest(_ip, port, url, mode="GET", log=log,header=input_param,
                                sleep=6, retry_times=10000,
                                content="query jsonrpc switch.")
    return result

def checkBgpServiceIR():
    '''
    调用 BgpService的IR，确保服务可用
    :return: 成功 0  失败 1
    '''  
    log = set_log(stream=True)
    _ip = get_local_ip()
    port = get_ir_port()
    url = "/rest/bgp/v1/bgp-site"
    result, _ = send_rest(_ip, port, url, mode="GET", log=log,
                                sleep=6, retry_times=10000,
                                content="query bgp site.")
    return result       

def main():
    log = set_log(stream=True)
    # 调用接口
