#!/usr/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
omp_ip=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.get_ip('0'))\"")
databackup_ip=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.get_ip('1'))\"")
service_ip=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.get_ip('2'))\"")
local_ip=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.get_local_ip())\"")
enable=$1
omp_root_pwd=$2
standby=$3
# 检测所有DCNOpenEMService，DCNService，BgpService 是否启动
function checkAllService(){
     echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Begin Check Key Services Start' 
     count=1
     while [ $(su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep DCNService | grep RUNNING | wc -l") -ne 3 ]
      do 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Services on some DCNService nodes are not started properly. try' $count
        count=$(($count+1))
        sleep 10s
     done
     count=1
     while [ $(su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep DCNOpenEMService | grep RUNNING | wc -l") -ne 3 ]
     do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Services on some DCNOpenEMService nodes are not started properly. try' $count
        count=$(($count+1))
        sleep 10s
    done
    count=1
    while [ $(su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -i BgpService | grep RUNNING | wc -l") -lt 2 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Services on some BgpService nodes are not started properly. try' $count
        count=$(($count+1))
        sleep 10s
    done
    echo  `date '+%Y-%m-%d %H:%M:%S'`[INFO]' End  Key Services is Started ok. ' 
}
# 检测DCNService IR 是否可以成功调用
function checkDCNServiceIR(){
    echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Start to check whether DCNService is available.'  
    count=0
    while [ $count -lt 3 ] 
    do 
        result=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.checkDCNServiceIR($count))\"")
        count=$(($count+1))
        sleep 6s
    done
    echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' DCNService is available.'
}
# 检测DCNOpenEMService IR 是否可以成功调用
function checkDCNOpenEMServiceIR(){
   echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Start to check whether DCNOpenEMService is available.' 
   count=0   
   while [  $count -lt 3 ] 
   do 
       result=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.checkDCNOpenEMServiceIR(${count}))\"")
       count=$(($count+1))
       sleep 6s
   done
   echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' DCNOpenEMService is available.'
}

# 检测BgpService IR 是否可以成功调用
function checkBgpServiceIR(){
    echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Start to check whether BgpService is available.'  
    count=0
    while [ $count -lt 3 ] 
    do 
        result=$(su - ossadm -c ". /opt/oss/manager/agent/bin/engr_profile.sh;python -c \"import sys;sys.path.append('${CUR_PATH}/');import call_ir;print(call_ir.checkBgpServiceIR())\"")
        count=$(($count+1))
        sleep 6s
    done
    echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' BgpService is available.'
}
## 支撑南向隔离和恢复南向隔离
## 约束：1、只能在OMP上执行、脚本主动跳转到其他节点执行。2、命令参照规范开展：sh main.sh on/off omp_root_pwd 
## 执行时机： 1、升级前执行命令：sh main.sh on omp_root_pwd 升级后执行：sh main.sh off omp_root_pwd
function main(){ 
    if [[ ${CUR_PATH} != '/tmp/Isolate' ]] 
    then
       echo `date '+%Y-%m-%d %H:%M:%S'`[ERROR]" Please put the tool in the /tmp/Isolate directory. "
       exit 0; 
    fi
    if [[ ${omp_ip} != ${local_ip} ]] 
    then
       echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]" Please the tool on the OMP node. "
       exit 0; 
    fi
    # 输出参数校验
    if [[ -z ${enable} ]] || [[ -z ${omp_root_pwd} ]] || ([[ ${enable} != 'off' ]] &&  [[ ${enable} != 'on' ]]) || ([[ ! -z ${standby} ]] && [[ ${standby} != 'slave' ]])
    then 
        echo `date '+%Y-%m-%d %H:%M:%S'`[ERROR]' Please Enter sh main.sh on/off omp_root_pwd [standby] , If the site is to be de-isolated, enter sh main.sh off omp_root_pwd slave.'
        exit 0;
    fi 
    IPS=${omp_ip},${databackup_ip},${service_ip}
    #暂不支持节点的面不一样
    #root_pwd=${omp_root_pwd},,,,,{backup_root_pwd},,,,,${service_root_pwd}
    #root_pwd_arr=(${root_pwd//,,,,,/ })
    IPS_array=(${IPS//,/ })
    node_num=${#IPS_array[*]}
    #校验密码
    for ((i=0;i< node_num;i++))
    do
        # 校验密码正确性
        chown ossadm:ossgroup $CUR_PATH/check_Pwd.sh
        su - ossadm -c "sh $CUR_PATH/check_Pwd.sh ${IPS_array[i]} '${omp_root_pwd}'"    
        if [[ $? != "0" ]]
        then
          exit 1;
        fi        
    done
    # 隔离
    if [[ ${enable} == 'on' ]]
    # 隔离
    then
        for ((i=0;i< node_num;i++))
        do
          # 隔离节点
          chown ossadm:ossgroup $CUR_PATH/remote_operation.sh
          su - ossadm -c "sh $CUR_PATH/remote_operation.sh ${IPS_array[i]} '${omp_root_pwd}' $CUR_PATH/Isolate.sh ${enable}"        
        done 
    fi
    if [[ ${enable} == 'off' ]]
    # 解除隔离
    then
        # 校验服务是否已经完全启动,如是备站点，不检测服务状态，直接隔离
        if [[ ${standby} != 'slave' ]]
        then 
            checkAllService
            # 校验DCNService是否OK
            checkDCNServiceIR 
            # 校验DCNOpenEMService是否OK
            checkDCNOpenEMServiceIR
            # 校验BGPService是否OK
            checkBgpServiceIR
        fi
        for ((i=0;i< node_num;i++))
        do
          # 解除节点隔离
           chown ossadm:ossgroup $CUR_PATH/remote_operation.sh
           su - ossadm -c "sh $CUR_PATH/remote_operation.sh ${IPS_array[i]} '${omp_root_pwd}' $CUR_PATH/Isolate.sh ${enable} ${standby}"          
        done
        
    fi
}
main

   
