#!/bin/bash
enable=$1
slave=$2
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
function onSouthbound(){
    #IPV6场景
    if [[ $(ip6tables -nvL INPUT | grep "tcp dpt:6653" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OpenFlow dport 6653'
        ip6tables -I INPUT -p tcp --dport 6653 -j DROP  
    fi
    if [[ $(ip6tables -nvL OUTPUT | grep "tcp spt:6653" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OpenFlow  sport 6653'
        ip6tables -I OUTPUT -p tcp --sport 6653 -j DROP  
    fi
    if [[ $(ip6tables -nvL OUTPUT | grep "tcp dpt:6640" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OVSDB dport 6640'
        ip6tables -I OUTPUT -p tcp --dport 6640 -j DROP  
    fi
    if [[ $(ip6tables -nvL INPUT | grep "tcp spt:6640" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OVSDB sport 6640'
        ip6tables -I INPUT -p tcp --sport 6640 -j DROP  
    fi
    
    if [[ $(ip6tables -nvL OUTPUT| grep "tcp spt:40960" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate JsonRPC OUTPUT sport 40960'
        ip6tables -I OUTPUT -p tcp --sport 40960 -j DROP  
    fi
    if [[ $(ip6tables -nvL INPUT | grep "tcp dpt:40960" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate JsonRPC INPUT dport 40960'
        ip6tables -I INPUT -p tcp --dport 40960 -j DROP  
    fi
    if [[ $(ip6tables -nvL OUTPUT | grep "tcp spt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP OUTPUT dport 179'
        ip6tables -I OUTPUT -p tcp --sport 179 -j DROP       
    fi
    if [[ $(ip6tables -nvL INPUT | grep "tcp spt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP INPUT dport 179'
        ip6tables -I INPUT -p tcp --sport 179 -j DROP         
    fi
    if [[ $(ip6tables -nvL OUTPUT | grep "tcp dpt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP dport 179'
        ip6tables -I OUTPUT -p tcp --dport 179 -j DROP      
    fi
    if [[ $(ip6tables -nvL INPUT | grep "tcp dpt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP INPUT dport 179'
        ip6tables -I INPUT -p tcp --dport 179 -j DROP         
    fi
    # 备份文件加时间鹾
    cp /etc/sysconfig/ip6tables /etc/sysconfig/ip6tables.auto.`date +"%Y%m%d%H%M"`
    ip6tables-save>/etc/sysconfig/ip6tables
    #IPV4场景
    if [[ $(iptables -nvL INPUT | grep "tcp dpt:6653" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OpenFlow dport 6653'
        iptables -I INPUT -p tcp --dport 6653 -j DROP  
    fi
    if [[ $(iptables -nvL OUTPUT | grep "tcp spt:6653" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OpenFlow  sport 6653'
        iptables -I OUTPUT -p tcp --sport 6653 -j DROP  
    fi
    if [[ $(iptables -nvL OUTPUT | grep "tcp dpt:6640" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OVSDB dport 6640'
        iptables -I OUTPUT -p tcp --dport 6640 -j DROP  
    fi
    if [[ $(iptables -nvL INPUT | grep "tcp spt:6640" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate OVSDB sport 6640'
        iptables -I INPUT -p tcp --sport 6640 -j DROP  
    fi
    
    if [[ $(iptables -nvL OUTPUT| grep "tcp spt:40960" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate JsonRPC OUTPUT sport 40960'
        iptables -I OUTPUT -p tcp --sport 40960 -j DROP  
    fi
    if [[ $(iptables -nvL INPUT | grep "tcp dpt:40960" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate JsonRPC INPUT dport 40960'
        iptables -I INPUT -p tcp --dport 40960 -j DROP  
    fi
    if [[ $(iptables -nvL OUTPUT | grep "tcp spt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP OUTPUT dport 179'
        iptables -I OUTPUT -p tcp --sport 179 -j DROP       
    fi
    if [[ $(iptables -nvL INPUT | grep "tcp spt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP INPUT dport 179'
        iptables -I INPUT -p tcp --sport 179 -j DROP         
    fi
    if [[ $(iptables -nvL OUTPUT | grep "tcp dpt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP dport 179'
        iptables -I OUTPUT -p tcp --dport 179 -j DROP      
    fi
    if [[ $(iptables -nvL INPUT | grep "tcp dpt:179$" | wc -l) -eq 0 ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' isolate BGP INPUT dport 179'
        iptables -I INPUT -p tcp --dport 179 -j DROP         
    fi
    # 备份文件加时间鹾
    cp /etc/sysconfig/iptables /etc/sysconfig/iptables.auto.`date +"%Y%m%d%H%M"`
    iptables-save>/etc/sysconfig/iptables
   }
   
function offSouthbound(){
 #IPV5 5GC场景，隔离南向三协议端口的
 while [ $(ip6tables -nvL OUTPUT | grep "tcp spt:6653" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OpenFlow OUTPUT sport 6653'
        ip6tables -D OUTPUT -p tcp --sport 6653 -j DROP 
    done
 while [ $(ip6tables -nvL INPUT | grep "tcp dpt:6653" | wc -l)  -gt 0 ]
    do
        ip6tables -D INPUT -p tcp --dport 6653 -j DROP 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OpenFlow INPUT dport 6653'
    done
 while [ $(ip6tables -nvL OUTPUT | grep "tcp dpt:6640" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OVSDB OUTPUT dport 6640'
        ip6tables -D OUTPUT -p tcp --dport 6640 -j DROP 
    done     
  while [ $(ip6tables -nvL INPUT | grep "tcp spt:6640" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OVSDB INPUT sport 6640'
        ip6tables -D INPUT -p tcp --sport 6640 -j DROP 
    done 
  while [ $(ip6tables -nvL OUTPUT | grep "tcp spt:40960" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate JsonRPC OUTPUT sport 40960'
        ip6tables -D OUTPUT -p tcp --sport 40960 -j DROP 
    done   
  while [ $(ip6tables -nvL INPUT | grep "tcp dpt:40960" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate JsonRPC INPUT dport 40960'
        ip6tables -D INPUT -p tcp --dport 40960 -j DROP 
    done  
  while [ $(ip6tables -nvL | grep "tcp dpt:179$" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP INPUT  dpt 179'
        ip6tables -D INPUT -p tcp --dport 179 -j DROP 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP OUTPUT  dpt 179'
        ip6tables -D OUTPUT -p tcp --dport 179 -j DROP 
    done  
  while [ $(ip6tables -nvL | grep "tcp spt:179$" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP OUTPUT Spt 179'
        ip6tables -D OUTPUT -p tcp --sport 179 -j DROP 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP INPUT Spt 179'
        ip6tables -D INPUT -p tcp --sport 179 -j DROP
    done   
    ip6tables-save>/etc/sysconfig/ip6tables
    
 #IPV4私有云场景，隔离南向三协议端口的
 while [ $(iptables -nvL OUTPUT | grep "tcp spt:6653" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OpenFlow OUTPUT sport 6653'
        iptables -D OUTPUT -p tcp --sport 6653 -j DROP 
    done
 while [ $(iptables -nvL INPUT | grep "tcp dpt:6653" | wc -l)  -gt 0 ]
    do
        iptables -D INPUT -p tcp --dport 6653 -j DROP 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OpenFlow INPUT dport 6653'
    done
 while [ $(iptables -nvL OUTPUT | grep "tcp dpt:6640" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OVSDB OUTPUT dport 6640'
        iptables -D OUTPUT -p tcp --dport 6640 -j DROP 
    done     
  while [ $(iptables -nvL INPUT | grep "tcp spt:6640" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate OVSDB INPUT sport 6640'
        iptables -D INPUT -p tcp --sport 6640 -j DROP 
    done 
  while [ $(iptables -nvL OUTPUT | grep "tcp spt:40960" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate JsonRPC OUTPUT sport 40960'
        iptables -D OUTPUT -p tcp --sport 40960 -j DROP 
    done   
  while [ $(iptables -nvL INPUT | grep "tcp dpt:40960" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate JsonRPC INPUT dport 40960'
        iptables -D INPUT -p tcp --dport 40960 -j DROP 
    done  
  while [ $(iptables -nvL | grep "tcp dpt:179$" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP INPUT  dpt 179'
        iptables -D INPUT -p tcp --dport 179 -j DROP 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP OUTPUT  dpt 179'
        iptables -D OUTPUT -p tcp --dport 179 -j DROP 
    done  
  while [ $(iptables -nvL | grep "tcp spt:179$" | wc -l)  -gt 0 ]
    do
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP OUTPUT Spt 179'
        iptables -D OUTPUT -p tcp --sport 179 -j DROP 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' unisolate BGP INPUT Spt 179'
        iptables -D INPUT -p tcp --sport 179 -j DROP
    done   
    iptables-save>/etc/sysconfig/iptables
}

function checkDCNOpenEMServiceLog(){
    echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Start to check whether route smoothing is complete.'
    cd /opt/oss/log/*/DCNOpenEMService/DCNOpenEMService*/log/
    #当前进程
    PID=$(ps -ef |grep DCNOpenEMService | grep org.apache.catalina.startup.Bootstrap | grep ossuser | awk  '{print $2}')
    #系统启动时间
    Start_TIME=$(ps -o lstart -p $PID| tail -n 1)
    Begin_TIME=$(date -d "$Start_TIME" +"%Y-%m-%d %H:%M:%S")
    # 进程启动日期
    yyyymmdd_start=$(date -d "$Begin_TIME" "+%Y%m%d")
    # 系统启动时间+一个小时
    End_TIME=$(date -d "$Begin_TIME 1 hour" +"%Y-%m-%d %H:%M:%S")
    # 进程启动日期+1小时后日期
    yyyymmdd_End=$(date -d "$End_TIME" "+%Y%m%d")
    time=1 
    while [[ $time -lt 100 ]]
    do 
      # 当前日志文件中查找
      count=$(grep "needPublish" openemservice.log | grep "OvsEventService" | awk '{print $1" "$2}' | awk  -v b="$Begin_TIME" -v e="$End_TIME"  '$1" "$2> b && $1" "$2< e'  | wc -l)
      if [[ $count -gt 0 ]]
      then 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Flow table smoothing completed. log file openemservice' 
        break;
      fi
       # 当前压缩文件中查找
      count=$(zgrep "needPublish" openemservice_${yyyymmdd_start}* | grep "OvsEventService" | awk '{print $1" "$2}' | awk -F '.zip:' '{print $2}' | awk  -v b="$Begin_TIME" -v e="$End_TIME"  '$1" "$2> b && $1" "$2< e' | wc -l)
      if [[ $count -gt 0 ]]
      then 
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Flow table smoothing completed. log file openemservice_'${yyyymmdd_start} 
        break;
      fi
      # 日志时间翻天
      if [[ $yyyymmdd_End != $yyyymmdd_start ]]
      then
          count=$(zgrep "needPublish" openemservice_${yyyymmdd_End}* | grep "OvsEventService" | awk '{print $1" "$2}' | awk -F '.zip:' '{print $2}' | awk  -v b="$Begin_TIME" -v e="$End_TIME"  '$1" "$2> b && $1" "$2< e' | wc -l)
          if [[ $count -gt 0 ]]
          then 
            echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Flow table smoothing completed. log file openemservice_'${yyyymmdd_End} 
            break;
          fi
      fi
      sleep 10s
      # 重试
      time=$(($time+1))
      echo `date '+%Y-%m-%d %H:%M:%S'`[warn]' Flow table smoothing is not complete. Try '.${time} 
    done
}

function main(){ 
   if [[ ${enable} == 'on' ]]
   then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' End isolate southbound'
        onSouthbound
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' End isolate southbound'
   fi
   if [[ ${enable} == 'off' ]]
   then
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' begin unisolate southbound'
        if [[ ${slave} != 'slave' ]]
        then
            checkDCNOpenEMServiceLog
        fi
        offSouthbound  
        echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' End unisolate southbound'
   fi
}
main
