#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: has_backup_table.sh
# Description: Generate data table that have been backed up.
###############################################################################


##################################################
# Description:  Create data table that have been backed up.
# Parameters:   null
##################################################
function create_has_backup_table() {
    log info "Start creating data table that have been backed up...."

    [ -f "${HAS_BACKUP_TABLE}" ] && rm -rf "${HAS_BACKUP_TABLE}"

    local timestamp_pkg_list=($(ls "${BACKUPDATA_TYPE_PATH}" |egrep ".*\.tar$"))
    for timestamp_pkg in ${timestamp_pkg_list[@]}
    do
        local timestamp_dir_name="${BACKUPDATA_TYPE_DIR_NAME}/${timestamp_pkg%.*}"
        local timestamp_pkg_file="${BACKUPDATA_TYPE_PATH}/${timestamp_pkg}"
        [ -f "${timestamp_pkg_file}" ] || {
        log error "The timestamp package ${timestamp_pkg_file}: No such file."; return 1; }

        echo "${timestamp_dir_name} ${timestamp_pkg_file}" >> "${HAS_BACKUP_TABLE}"
    done

    if [ -f "${HAS_BACKUP_TABLE}" ]; then
        chmod 600 "${HAS_BACKUP_TABLE}" || {
        log error "Change permissions ${HAS_BACKUP_TABLE}: Change failed."; return 1; }
    fi
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_has_backup_table() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start generating data table that have been backedup...."

    create_has_backup_table || return $?
}

main_has_backup_table