#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: need_backup_table.sh
# Description: Generate data table that need to be backed up.
###############################################################################


##################################################
# Description:  Create data table that need to be backed up.
# Parameters:   null
##################################################
function create_need_backup_table() {
    log info "Start creating data table that need to be backed up...."

    local need_backup_table_temp_name="${BACKUP_DATA_TYPE}_need_backup.table.temp"

    [ -f "${NEED_BACKUP_TABLE}" ] && rm -rf "${NEED_BACKUP_TABLE}"

    local sftp_temp_conf_path="${sftp_backup_path}/${SFTP_BACKUPDATA_TEMP_CONF_PATH}"
    local temp_data_raw_type_path="${BACKUPDATA_TEMP_RAW_PATH}/${BACKUPDATA_TYPE_DIR_NAME##*/}"

    log info "Start executing command...."

    local cmd="ls ${temp_data_raw_type_path} > ${BACKUPDATA_TEMP_CONF_PATH}/${need_backup_table_temp_name}"
    execute_expect_connection "sshcmd" "${cmd}" || {
    log error "Execute command ${cmd}, return $?: Execute failed."; return 1; }

    local cmd="put ${BACKUPDATA_TEMP_CONF_PATH}/${need_backup_table_temp_name} ${sftp_temp_conf_path}"
    execute_expect_connection "sshsftp" "${cmd}" || {
    log error "Execute command ${cmd}, return $?: Execute failed."; return 1; }

    local cmd="get ${sftp_temp_conf_path}/${need_backup_table_temp_name} ${BACKUPDATA_TEMP_CONF_PATH}"
    execute_expect_connection "sftpcmd" "${cmd}" || {
    log error "Execute command ${cmd}, return $?: Execute failed."; return 1; }

    [ -f "${BACKUPDATA_TEMP_CONF_PATH}/${need_backup_table_temp_name}" ] || {
    log warning "The data table ${BACKUPDATA_TEMP_CONF_PATH}/${need_backup_table_temp_name}: No such file."; return 0; }

    cat "${BACKUPDATA_TEMP_CONF_PATH}/${need_backup_table_temp_name}" |sort -rV |head -n "${MAX_BACKUP_PKG_NUM}" |sed \
        "s#\(^[0-9+]\)\(.*\)#${BACKUPDATA_TYPE_DIR_NAME}/\1\2#g" > "${NEED_BACKUP_TABLE}"

    if [ ! -s "${NEED_BACKUP_TABLE}" ]; then
        log error "The need backup table ${NEED_BACKUP_TABLE}: File is empty."
        log error "Please check whether backup data exists on the backup server."
        return 1
    fi

    if [ -f "${NEED_BACKUP_TABLE}" ]; then
        chmod 600 "${NEED_BACKUP_TABLE}" || {
        log error "Change permissions ${NEED_BACKUP_TABLE}: Change failed."; return 1; }
    fi
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_need_backup_table() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start generating data table that need to be backedup...."

    read -rs -t 3 passwd1
    read -rs -t 3 passwd2
    read -rs -t 3 passwd3
    local allpasswd="${passwd1} ${passwd2} ${passwd3}"

    local login_ip=""
    local sftp_ip=""
    local login_user=""
    local login_passwd=""
    local execute_user=""
    local execute_passwd=""
    local sftp_user=""
    local sftp_passwd=""
    local sftp_backup_path=""

    source "${MINI_BACKUP_ACCOUNT_INFO_PATH}"/read_account.sh "execute" "${allpasswd}" || {
    log error "Failed to read account information."; return 1; }
    source "${MINI_BACKUP_ACCOUNT_INFO_PATH}"/read_account.sh "sftp" "${allpasswd}" || {
    log error "Failed to read account information."; return 1; }

    create_need_backup_table "${allpasswd}" || return $?
}

main_need_backup_table