#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: not_backup_table.sh
# Description: Generate data table that have not been backed up.
###############################################################################


##################################################
# Description:  Check whether has-backup files need to be compared.
# Parameters:   null
##################################################
function is_need_compare() {
    log info "Start checking whether has-backup files need to be compared...."

    # The first backup data is full backup
    if [ ! -s "${HAS_BACKUP_TABLE}" ]; then
        log info "This is the first time to backup ${BACKUP_DATA_TYPE} data, full backup will be performed...."
        cat "${NEED_BACKUP_TABLE}" > "${NOT_BACKUP_TABLE}" && chmod 600 "${NOT_BACKUP_TABLE}"
        return 1
    fi

    return 0
}

##################################################
# Description:  Create data table that have not been backed up.
# Parameters:   null
##################################################
function create_not_backup_table() {
    log info "Start creating data table that have not been backed up...."

    [ -f "${NOT_BACKUP_TABLE}" ] && rm -rf "${NOT_BACKUP_TABLE}"

    while read data || [ -n "${data}" ]
    do
        local timestamp_dir_name=$(awk -F ' ' '{print $1}' <<< "${data}")
        [ -n "${timestamp_dir_name}" ] || {
        log error "The timestamp dir name of ${data}: No such string."; return 1; }

        grep -qw "${timestamp_dir_name}" "${HAS_BACKUP_TABLE}" || echo "${data}" >> "${NOT_BACKUP_TABLE}"
    done < "${NEED_BACKUP_TABLE}"

    if [ -f "${NOT_BACKUP_TABLE}" ]; then
        chmod 600 "${NOT_BACKUP_TABLE}" || {
        log error "Change permissions ${NOT_BACKUP_TABLE}: Change failed."; return 1; }
    fi
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_not_backup_table() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start generating data table that have not been backedup...."

    is_need_compare || exit 0
    create_not_backup_table || return $?
}

main_not_backup_table