#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: redundant_backup_table.sh
# Description: Generate data table for redundant backup.
###############################################################################


##################################################
# Description:  Check whether has-backup files need to be compared.
# Parameters:   null
##################################################
function is_need_compare() {
    log info "Start checking whether has-backup files need to be compared...."

    # There is no redundancy in the first backup data
    if [ ! -s "${HAS_BACKUP_TABLE}" ]; then
        log info "This is the first time to backup ${BACKUP_DATA_TYPE} data, there is no redundancy data."
        return 1
    fi

    return 0
}

##################################################
# Description:  Create data table for redundant backup.
# Parameters:   null
##################################################
function create_redundant_backup_table() {
    log info "Start creating data table for redundant backup...."

    [ -f "${REDUNDANT_BACKUP_TABLE}" ] && rm -rf "${REDUNDANT_BACKUP_TABLE}"

    while read data || [ -n "${data}" ]
    do
        local timestamp_dir_name=$(awk -F ' ' '{print $1}' <<< "${data}")
        [ -n "${timestamp_dir_name}" ] || {
        log error "The timestamp dir name of ${data}: No such string."; return 1; }

        grep -qw "${timestamp_dir_name}" "${NEED_BACKUP_TABLE}" || echo "${data}" >> "${REDUNDANT_BACKUP_TABLE}"
    done < "${HAS_BACKUP_TABLE}"

    if [ -f "${REDUNDANT_BACKUP_TABLE}" ]; then
        chmod 600 "${REDUNDANT_BACKUP_TABLE}" || {
        log error "Change permissions ${REDUNDANT_BACKUP_TABLE}: Change failed."; return 1; }
    fi
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_redundant_backup_table() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start generating data table for redundant backup...."

    is_need_compare || exit 0
    create_redundant_backup_table || return $?
}

main_redundant_backup_table