#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: prepare_backup_data.sh
# Description: Prepare backup data.
###############################################################################


##################################################
# Description:  Download backup data.
# Parameters:   null
##################################################
function download_backup_data() {
    log info "Start downloading backup data...."

    local sftp_backupdata_type_path="${sftp_backup_path}/${BACKUPDATA_TYPE_DIR_NAME}"

    log info "Start executing command...."

    local cmd="get -r ${sftp_backupdata_type_path} ${BACKUPDATA_TEMP_RAW_PATH}"
    execute_expect_connection "sshsftp" "${cmd}" "${MAX_SFTP_TIMEOUT}" || {
    log error "Execute command ${cmd}, return $?: Execute failed."; return 1; }
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_prepare_backup_data() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start preparing backup data...."

    read -rs -t 3 passwd1
    read -rs -t 3 passwd2
    read -rs -t 3 passwd3
    local allpasswd="${passwd1} ${passwd2} ${passwd3}"

    local login_ip=""
    local sftp_ip=""
    local login_user=""
    local login_passwd=""
    local execute_user=""
    local execute_passwd=""
    local sftp_user=""
    local sftp_passwd=""
    local sftp_backup_path=""

    source "${MINI_BACKUP_ACCOUNT_INFO_PATH}"/read_account.sh "execute" "${allpasswd}" || {
    log error "Failed to read account information."; return 1; }
    source "${MINI_BACKUP_ACCOUNT_INFO_PATH}"/read_account.sh "sftp" "${allpasswd}" || {
    log error "Failed to read account information."; return 1; }

    download_backup_data || return $?
}

main_prepare_backup_data