#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: prepare_backup_directory.sh
# Description: Prepare backup directory.
###############################################################################


##################################################
# Description:  Create backup directory.
# Parameters:   null
##################################################
function create_backup_directory() {
    log info "Start creating backup directory...."

    local sftp_temp_path="${sftp_backup_path}/${SFTP_BACKUPDATA_TEMP_PATH}"
    local sftp_temp_data_path="${sftp_backup_path}/${SFTP_BACKUPDATA_TEMP_DATA_PATH}"
    local sftp_temp_conf_path="${sftp_backup_path}/${SFTP_BACKUPDATA_TEMP_CONF_PATH}"

    # mini system
    mkdir -p "${BACKUPDATA_TEMP_DATA_PATH}" "${BACKUPDATA_TEMP_CONF_PATH}" || return $?

    log info "Start executing command...."

    # backup node
    local cmd="mkdir -p ${BACKUPDATA_TEMP_RAW_PATH} ${BACKUPDATA_TEMP_NEW_PATH} ${BACKUPDATA_TEMP_CONF_PATH}"
    execute_expect_connection "sshcmd" "${cmd}" || {
    log error "Execute command ${cmd}, return $?: Execute failed."; return 1; }

    local cmd="mkdir ${sftp_temp_path}"
    execute_expect_connection "sftpcmd" "${cmd}" || true

    local cmd="mkdir ${sftp_temp_data_path}"
    execute_expect_connection "sftpcmd" "${cmd}" || true

    local cmd="mkdir ${sftp_temp_conf_path}"
    execute_expect_connection "sftpcmd" "${cmd}" || true
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_prepare_backup_directory() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start preparing backup directory...."

    read -rs -t 3 passwd1
    read -rs -t 3 passwd2
    read -rs -t 3 passwd3
    local allpasswd="${passwd1} ${passwd2} ${passwd3}"

    local login_ip=""
    local sftp_ip=""
    local login_user=""
    local login_passwd=""
    local execute_user=""
    local execute_passwd=""
    local sftp_user=""
    local sftp_passwd=""
    local sftp_backup_path=""

    source "${MINI_BACKUP_ACCOUNT_INFO_PATH}"/read_account.sh "execute" "${allpasswd}" || {
    log error "Failed to read account information."; return 1; }
    source "${MINI_BACKUP_ACCOUNT_INFO_PATH}"/read_account.sh "sftp" "${allpasswd}" || {
    log error "Failed to read account information."; return 1; }

    create_backup_directory "${allpasswd}" || return $?
}

main_prepare_backup_directory