#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: log_module.sh.sh
# Description: Log module public definition.
###############################################################################


##################################################
# Description:  print log.
# Parameters:   level message [--nostd]
#               level: {info | warning | error}
#               message: string message
#               --nostd: do not display to standard output stream, only print to log file
#Instructions:  log info "this is info message" --nostd
#               log error "this is error message"
##################################################
function log() {
    local loglevel="$1"
    local logmsg="$2"
    local nostd="$3"

    local logformat=""
    local location=""
    local script=""
    local fncall=""
    local codeline=""
    local datetime=$(date +'%F %T')
    local callernum=$(egrep -o 'caller[0-9]+' <<< "$@" |awk -F 'caller' '{print $2}')

    [ -z "${callernum}" ] && callernum=0

    if [[ "${loglevel}" =~ "error" ]] || [[ "${loglevel}" =~ "warning" ]]; then
        fncall="${FUNCNAME[1]}"
        caller_info=($(caller ${callernum}))
        script="${caller_info[2]}"
        fncall="${caller_info[1]}"
        codeline="${caller_info[0]}"
        [ -n "${script}" -a -n "${fncall}" -a -n "${codeline}" ] && location="[${codeline} ${fncall} ${script##*/}]"
    fi

    logformat="${datetime} ${loglevel} ${location} ${logmsg}"

    [ "${nostd}" = "--nostd" ] && echo -e "${logformat}" >> "${LOGFILE}" || echo -e "${logformat}" |tee -a "${LOGFILE}"
}

##################################################
# Description:  returns the status code of the previous command and output the exception log.
# Parameters:   level message [--nostd]
##################################################
function is_exception_status() {
    local status="$?"
    local params="$@"

    [ "${status}" -ne 0 ] && log "${params}" "caller1"

    return "${status}"
}