#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: check_backup_data.sh
# Description: Check backup data.
###############################################################################


##################################################
# Description:  Check backup data table information.
# Parameters:   null
##################################################
function check_backup_table() {
    log info "Start to checking backup data table information...."

    if [ ! -s "${HAS_BACKUP_TABLE}" ]; then
        log warning "No local backup data found, will be backed up."
        return 1
    fi

    if [ ! -s "${NEED_BACKUP_TABLE}" -o ! -s "${FINISH_BACKUP_TABLE}" ]; then
        log warning "No node backup data found, will be backed up."
        return 1
    fi

    while read data || [ -n "${data}" ]
    do
        local timestamp_dir_name=$(awk -F ' ' '{print $1}' <<< "${data}")
        local timestamp_name="${timestamp_dir_name##*/}"

        if ! grep -qw "${timestamp_name}" "${FINISH_BACKUP_TABLE}"; then
            log warning "The backup data ${timestamp_name} is abnormal, will be backed up."
            return 1
        fi
    done < "${NOT_BACKUP_TABLE}"

    return 0
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_check_backup_data() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start checking backup data...."

    check_backup_table || return $?
}

main_check_backup_data