#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: common_definition.sh
# Description: Common definition of backup service.
###############################################################################


##################################################
# Description:  define backup service dynamic variables.
# Parameters:   type
##################################################
function define_backup_dynamic_var() {
    # It needs to be included after the public definition
    export BACKUP_DATA_TYPE="$1"
    export BACKUP_LOGIN_IP="${2%% *}"
    export BACKUP_SFTP_IP="${2##* }"

    export MAX_BACKUP_PKG_NUM=$(egrep -w "^MAX_BACKUP_PKG_NUM=[0-9]+" ${CONFIGURE_PARAMETERS_CONF} |head -1 |awk -F '=' '{print $2}')
    export MAX_SSH_TIMEOUT=$(egrep -w "^MAX_SSH_TIMEOUT=[0-9]+" ${CONFIGURE_PARAMETERS_CONF} |head -1 |awk -F '=' '{print $2}')
    export MAX_SFTP_TIMEOUT=$(egrep -w "^MAX_SFTP_TIMEOUT=[0-9]+" ${CONFIGURE_PARAMETERS_CONF} |head -1 |awk -F '=' '{print $2}')
}

##################################################
# Description:  define backup product name variables.
# Parameters:   product_name
##################################################
function define_backup_product_name_var() {
    # It needs to be included after the public definition
    [ "$1" = "${INPUT_TYPE_PRODUCTDATA}" ] && {
        export BACKUPDATA_TYPE_DIR_NAME="$2/dynamic"
        export BACKUPDATA_TYPE_PATH="${BACKUPDATA_ROOT_PATH}/${BACKUPDATA_TYPE_DIR_NAME}"
        export BACKUPDATA_TYPE_FINISH_TAG_SIGN="finish.tag.sign"
    }
}

##################################################
# Description:  create backup service dynamic files.
# Parameters:   null
##################################################
function create_backup_dynamic_files() {
    mkdir -p "${BACKUPDATA_TYPE_PATH}"

    find "${BACKUPDATA_ROOT_PATH}" -type d |xargs -I {} chmod 700 {}
    find "${BACKUPDATA_ROOT_PATH}" -type f |xargs -I {} chmod 400 {}

}

##################################################
# Description:  main function.
# Parameters:   null
##################################################
function mian_common_definition() {
    local workspace="$(dirname $(readlink -f ${BASH_SOURCE[0]}))"

    source "${workspace}"/constant_declaration || return $?
    source "${workspace}"/check_function.sh || return $?
    source "${workspace}"/expect_function.sh || return $?
    source "${workspace}"/execute_function.sh || return $?
}

mian_common_definition