#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: check_function.sh
# Description: Perform related functions.
###############################################################################

##################################################
# Description:  Execute expect connection.
# Parameters:   type command
##################################################
function execute_expect_connection() {
    local allow_type_list=("sshcmd" "sshsftp" "sftpcmd")
    local curr_type="$1"
    local cmd="$2"
    local timeout="$3"

    local retry_number=3
    local retry_interval=30

    grep -qw "${curr_type}" <<< "${allow_type_list[@]}" || {
    log error "The expect connection type ${curr_type}: Type not allowed."; return 1; }

    for ((i=1; i<="${retry_number}"; i++)); do
        if [ "${curr_type}" = "sshcmd" ]; then
            expect_connection_ssh --loginip "${login_ip}" --loginuser "${login_user}" --loginpwd "${login_passwd}" \
                --executeuser "${execute_user}" --executepwd "${execute_passwd}" \
                --sshcmd "${cmd}" --sshtimeout "${timeout}" &>> "${LOGFILE}" && return $?
        fi

        if [ "${curr_type}" = "sshsftp" ]; then
            expect_connection_ssh --loginip "${login_ip}" --loginuser "${login_user}" --loginpwd "${login_passwd}" \
                --executeuser "${execute_user}" --executepwd "${execute_passwd}" \
                --sftpip "${sftp_ip}" --sftpuser "${sftp_user}" --sftppwd "${sftp_passwd}" \
                --sftpcmd "${cmd}" --sftptimeout "${timeout}" &>> "${LOGFILE}" && return $?
        fi

        if [ "${curr_type}" = "sftpcmd" ]; then
            expect_connection_sftp --sftpip "${sftp_ip}" --sftpuser "${sftp_user}" --sftppwd "${sftp_passwd}" \
                --sftpcmd "${cmd}" --sftptimeout "${timeout}" &>> "${LOGFILE}" && return $?
        fi

        [ "${i}" -eq "${retry_number}" ] && return 1
        sleep "${retry_interval}"
    done
}