#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: delete_minirestore_data.sh
# Description: Delete minirestore data.
###############################################################################


##################################################
# Description:  Delete minirestore incomplete data.
# Parameters:   null
##################################################
function delete_minirestore_incomplete_data() {
    log info "Start deleting minirestore incomplete data...."

    # Do not execute without new data
    if [ ! -s "${NOT_BACKUP_TABLE}" ]; then
        log info "No new bakcup data found, no need to delete."
        return 0
    fi

    [ ! -f "${FINISH_BACKUP_TABLE}" ] && > "${FINISH_BACKUP_TABLE}"

    while read data || [ -n "${data}" ]
    do
        local timestamp_dir_name=$(awk -F ' ' '{print $1}' <<< "${data}")
        local timestamp_name="${timestamp_dir_name##*/}"
        [ -n "${timestamp_dir_name}" ] || {
        log error "The timestamp dir name of ${data}: No such string."; return 1; }

        grep -qw "${timestamp_name}" "${FINISH_BACKUP_TABLE}" || rm -f "${BACKUPDATA_ROOT_PATH}"/"${timestamp_dir_name}"*
    done < "${NOT_BACKUP_TABLE}"

    return 0
}

##################################################
# Description:  Delete minirestore redundant data.
# Parameters:   null
##################################################
function delete_minirestore_redundant_data() {
    log info "Start deleting minirestore redundant data...."

    # Redundant backup table is empty
    if [ ! -s "${REDUNDANT_BACKUP_TABLE}" ]; then
        log info "No redundant data found, no need to delete."
        return 0
    fi

    while read data || [ -n "${data}" ]
    do
        local timestamp_dir_name=$(awk -F ' ' '{print $1}' <<< "${data}")
        local timestamp_pkg_file=$(awk -F ' ' '{print $2}' <<< "${data}")
        [ -f "${timestamp_pkg_file}" ] || {
        log warning "The timestamp package ${timestamp_pkg_file}: No such file."; return 1; }

        [ -f "${timestamp_pkg_file}" ] && rm -f "${timestamp_pkg_file}"
    done < "${REDUNDANT_BACKUP_TABLE}"

    return 0
}

##################################################
# Description:  Delete minirestore temporary files.
# Parameters:   null
##################################################
function delete_minirestore_temp_files() {
    log info "Start deleting minirestore temporary files...."

    # mini system
    [ -d "${BACKUPDATA_TEMP_PATH}" ] && rm -rf "${BACKUPDATA_TEMP_PATH}"/*

    return 0
}

##################################################
# Description:  main function.
# Parameters:   $@
##################################################
function main_delete_minirestore_data() {
    source "${PUBLIC_DEFINITION_PATH}"/public_definition.sh
    source "${MINI_BACKUP_COMMON_DEFINITION_PATH}"/common_definition.sh

    log info "Start deleting unnecessary data...."

    delete_minirestore_incomplete_data || return $?
    delete_minirestore_redundant_data || return $?
    delete_minirestore_temp_files || return $?
}

main_delete_minirestore_data