#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: init_backup.sh
# Description: Deploy backup services.
###############################################################################


##################################################
# Description:  Deploy backup services.
# Parameters:   null
##################################################
function deploy_backup_service() {
    echo "Start deploying backup services...."

    local deploy_root_path="${workspace}/../.."
    local deploy_material_path="${deploy_root_path}/material"
    local deploy_tools_path="${deploy_root_path}/bin/tools"
    local service_dir_list=("bin" "conf" "python" "pyc")
    local create_dir_list=("${CONF_ACCOUNT_PATH}" "${CONF_TABLE_PATH}" "${CONF_PRODUCT_PATH}" "${CONF_CIPHER_PATH}"
                            "${CONF_CUSTOM_PATH}" "${CIPHER_MASTER_KEY_PATH}" "${CIPHER_WORK_KEY_PATH}"
                            "${BACKUPMATE_COMPONENT_PATH}" "${BACKUPMATE_SALT_PATH}")

    for dir in ${service_dir_list[@]}; do
        [ -d "${deploy_root_path}/${dir}" ] || {
        echo "Error, The directory ${deploy_root_path}/${dir}: No such directory."; return 1; }

        cp -rf "${deploy_root_path}/${dir}" "${BACKUPSERVICE_ROOT_PATH}" || return $?
    done

    for dir in ${create_dir_list[@]}; do
        mkdir -p "${dir}" || return $?
    done

    cp -rf "${deploy_material_path}"/* "${BACKUPMATE_COMPONENT_PATH}" || return $?
    cp -rf "${deploy_tools_path}"/* "${BACKUPTOOLS_ROOT_PATH}" || return $?

    rm -rf "${BACKUPTOOLS_ROOT_PATH}/init_backup_service.sh"
    rm -rf "${BACKUPSERVICE_BIN_PATH}/tools"
}

##################################################
# Description:  Link dependent libraries
# Parameters:   null
##################################################
function link_dependent_libs() {
    # Workaround, adapt to the old version of R7 docker
    echo "Start linking dependent libraries...."

    local depend_link_name_list=('libffi.so.6')
    local depend_lib_path_list=('/usr/lib64')

    if [ "${#depend_link_name_list[@]}" -ne "${#depend_lib_path_list[@]}" ]; then
        echo "Error, The number of link files does not match the number of library directories."
        return 1
    fi

    for index in ${!depend_link_name_list[@]}; do
        local link_file="${depend_lib_path_list[index]}/${depend_link_name_list[index]}"
        [ -f "${link_file}" ] && continue

        local lib_file=$(find "${depend_lib_path_list[index]}" -type f -name "${depend_link_name_list[index]%.*}.*")
        if [ ! -f "${lib_file}" ]; then
            echo "Error, Failed to find ${lib_name} library file in ${depend_lib_path_list[index]} directory."
            return 1
        fi

        cd "${depend_lib_path_list[index]}" || return $?
        ln -s "${lib_file##*/}" "${depend_link_name_list[index]}" || return $?
    done
}

##################################################
# Description:  Deploy file permissions.
# Parameters:   null
##################################################
function deploy_file_permissions() {
    echo "Start deploying file permissions...."

    chown root:ossgroup "${BACKUPSERVICE_ROOT_PATH}"
    chmod 750 "${BACKUPSERVICE_ROOT_PATH}"

    chown -R ossadm:ossgroup "${BACKUPMATE_ROOT_PATH}"
    chmod 700 "${BACKUPMATE_ROOT_PATH}"

    chown -R ossadm:ossgroup "${BACKUPDATA_ROOT_PATH}"
    chmod 700 "${BACKUPDATA_ROOT_PATH}"

    chown -R root:root "${BACKUPTOOLS_ROOT_PATH}"
    chmod 700 "${BACKUPTOOLS_ROOT_PATH}"

    chown ossadm:ossgroup "${BACKUPDATA_TEMP_PATH}"
    chmod 700 "${BACKUPDATA_TEMP_PATH}"

    chown -R root:ossgroup "${BACKUPSERVICE_BIN_PATH}"
    chmod 750 "${BACKUPSERVICE_BIN_PATH}"
    chown -R root:ossgroup "${BACKUPSERVICE_PYTHON_PATH}"
    chmod 750 "${BACKUPSERVICE_PYC_PATH}"
    chown -R root:ossgroup "${BACKUPSERVICE_PYC_PATH}"
    chmod 750 "${BACKUPSERVICE_PYTHON_PATH}"
    chown -R ossadm:ossgroup "${BACKUPSERVICE_CONF_PATH}"
    chmod 700 "${BACKUPSERVICE_CONF_PATH}"
    chown -R ossadm:ossgroup "${LOGPATH}"
    chmod 700 "${LOGPATH}"

    find "${BACKUPSERVICE_BIN_PATH}" -type d |xargs chmod 750
    find "${BACKUPSERVICE_BIN_PATH}" -type f |xargs chmod 550
    find "${BACKUPSERVICE_PYTHON_PATH}" -type d |xargs chmod 750
    find "${BACKUPSERVICE_PYTHON_PATH}/bin" -type f |xargs chmod 550
    find "${BACKUPSERVICE_PYC_PATH}" -type f |xargs chmod 550
    find "${BACKUPSERVICE_CONF_PATH}" -type d |xargs chmod 700
    find "${BACKUPSERVICE_CONF_PATH}" -type f |xargs chmod 600
    find "${BACKUPMATE_ROOT_PATH}" -type d |xargs chmod 700
    find "${BACKUPMATE_ROOT_PATH}" -type f |xargs chmod 600
    find "${BACKUPTOOLS_ROOT_PATH}" -type f |xargs chmod 500
}

##################################################
# Description:  main function.
# Parameters:   null
##################################################
function main_init_backup() {
    echo "Start initializing backup service...."

    local workspace="$(dirname $(readlink -f $0))"

    source "${workspace}"/../public_definition/public_definition.sh

    create_static_files || return $?

    deploy_backup_service || return $?
    link_dependent_libs || return $?
    deploy_file_permissions || return $?

    echo "The backup service initialized successfully!"
}

main_init_backup