# 云平台插件开发指导

---
修订记录:

|    日期     | 修订版本 |   作者  | 修改描述 |
| :--------- | :------ | :----- | :----- |
| 2022-04-24 | V 0.1.0 | 吴志超 | 初版 |

## 1. 概述

云平台插件开发主要关注(*"networking_huawei/drivers/ac"* 目录下):

+ extensions：扩展,添加新资源、新的操作或额外的属性来扩展现有的核心 API 资源。优点：1.无需更改源代码;2.可定制;
+ plugins：插件,neutron提供API功能的核心组件。
+ db：数据库相关。
    - migration：数据库预置脚本：如表结构信息，供升级安装部署使用。
    - *_schema.py：定义数据库模型
    - *_db.py：调用数据库相关操作，直接与数据库打交道的地方。
+ neutron_client：扩展neutron命令行

云平台插件从调用方式来分主要有：

1. 使用 HTTP/HTTPS 请求的方式调用
    - SSH登录到云平台插件安装所在节点，执行
      ```shell  
      # 先获取token
      export TOKEN=`openstack token issue | grep -w id |awk '{print $4}'`
      curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X GET http://controller:9696/v2.0/networks
      ```  
      执行结果：![network查询结果](./images/network查询Curl命令执行结果.PNG)

2. 通过命令行执行命令的方式调用  
   从本质上来说其实方式2内部也是在调用方式1执行相应操作。下面我们以 *"查询network"* 这个功能为例，简单介绍下这2种方式。
    - SSH登录到云平台插件安装所在节点，导入环境变量后，执行
      ```shell
      # 导入环境变量: source admin-openrc
      # 老版本对应命令: neutron net-list 
      openstack network list
      ```  
      执行结果：![network查询结果](./images/network查询命令执行结果.PNG)

## 2. 开发环境搭建

开发环境推荐：
- Python 3.x
- 开发IDEA：PyCharm

1. 下载云平台插件xft的代码，参考 http://3ms.huawei.com/km/groups/3125615/blogs/details/8267429?l=zh-cn

```shell
git mm init -u https://szv-y.codehub.huawei.com/NCE-Fabric/Manifest.git -b br_Dev_iMaster_NCE_Fabric -m br_Dev_iMaster_NCE_Fabric.xml -g all
git mm sync cloudintegration
git mm start local_xft
```

2. 安装依赖库及项目

- 进入刚刚项目代码路径，下载第三方依赖库

```shell
cd cloudintegration
pip install -r requirements.txt
```

- 从 github 下载依赖项目

```shell
mkdir github_openstack
cd github_openstack/
# 从github下载依赖源码， requirements.txt后面列出的内容
git clone https://github.com/openstack/neutron.git
git clone https://github.com/openstack/oslo.cache.git
git clone https://github.com/openstack/oslo.db.git
git clone https://github.com/openstack/oslo.metrics.git
git clone https://github.com/openstack/oslo.serialization.git
git clone https://github.com/openstack/osprofiler.git
git clone https://github.com/openstack/neutron-lib.git
git clone https://github.com/openstack/oslo.concurrency.git
git clone https://github.com/openstack/oslo.i18n.git
git clone https://github.com/openstack/oslo.middleware.git
git clone https://github.com/openstack/oslo.service.git
git clone https://github.com/openstack/os-service-types.git
git clone https://github.com/openstack/openstacksdk.git
git clone https://github.com/openstack/oslo.config.git
git clone https://github.com/openstack/oslo.log.git
git clone https://github.com/openstack/oslo.policy.git
git clone https://github.com/openstack/oslo.utils.git
git clone https://github.com/openstack/os-traits.git
git clone https://github.com/openstack/os-ken.git
git clone https://github.com/openstack/oslo.context.git
git clone https://github.com/openstack/oslo.messaging.git
git clone https://github.com/openstack/oslo.privsep.git
git clone https://github.com/openstack/oslo.versionedobjects.git
git clone https://github.com/openstack/python-neutronclient.git
```

3. pycharm打开云平台插件项目 配置依赖依赖：文件-->配置-->项目-->项目结构-->添加内容跟，如下图所示

![network查询结果](./images/配置依赖项目.PNG)

## 3.开发步骤

下面以一个例子讲解下具体开发流程，例子功能主要是处理云平台插件配置相关，功能有：1、读取云平台插件配置保存到数据库；2、查询云平台插件配置。

### 3.1 数据库

1. 首先定义数据库模型，即数据库表结构，假如表结构如下：

|     字段    |     类型     |     说明    |
| :---------- | :---------- | :---------- |
| id | int | 主键,auto |
| config_file | char(255) | 配置文件路径 |
| owner | char(128) | 配置文件所有者 |
| user_group | char(128) | 配置文件所在组 |
| right | char(10) | 配置文件权限 |
| create_time | datetime | 创建时间 |
| config_value | blob | 配置内容,字典描述 |

我们在 *networking_huawei/drivers/ac/db* 目录下新建包 *config_check*,将对应的模型类放到 *ac_config_schema.py*内，模型类代码如下:

```python
import sqlalchemy as sa
from oslo_utils import uuidutils
try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base
    
class ACBasicConfig(model_base.BASEV2):
    """AC配置信息数据库模型"""
    __tablename__ = 'huawei_ac_basic_config'

    id = sa.Column(sa.String(36), primary_key=True, default=uuidutils.generate_uuid)
    # 配置文件名
    config_file = sa.Column(sa.String(255), nullable=False)
    # 文件所有者
    owner = sa.Column(sa.String(128), nullable=False)
    # 文件所属用户组
    user_group = sa.Column(sa.String(128), nullable=False)
    # 文件权限
    right = sa.Column(sa.String(10), nullable=False)
    # 文件内容
    config_value = sa.Column(sa.PickleType, default={})
    # 创建时间
    create_time = sa.Column(sa.DateTime, default=sa.func.now())

    def __repr__(self):
        return str(self.to_dict())
    
    @classmethod
    def from_dict(cls, ac_config):
        """从字典中生成模型"""
        return ACBasicConfig(
            config_file=ac_config.get('config_file'),
            owner=ac_config.get('owner'),
            user_group=ac_config.get('user_group'),
            right=ac_config.get('right'),
            config_value=ac_config.get('config_value', {}), )

    def to_dict(self):
        """模型转化成字典"""
        return {'id': self.id, 'config_file': self.config_file, 'owner': self.owner, 'user_group': self.user_group,
                'right': self.right, 'create_time': self.create_time, 'config_value': self.config_value}
```

2. 编写数据库升级脚本  
   根据数据库结构，这里是新建数据库表，在 *"networking_huawei/drivers/ac/db/migration/alembic_migrations/versions"* 目录下新建一个py文件，文件名格式是 **"
   版本号_脚本名称"**。假如当前版本为 **a00000000001**（注：可以通过查询 **"huawei_ac_alembic_version"** 表来查看当前版本号），假设新增脚本版本号为 **a00000000002**
   ，则名称可以为 **"a00000000002_huawei_ac_sql.py"**。文件内容为

```python
import sqlalchemy as sa
from alembic import op

from neutron.db import migration
from oslo_utils import uuidutils

# revision identifiers, used by Alembic.
revision = 'a00000000002' # 当前脚本版本号
down_revision = 'a00000000001' # 上个脚本版本号
depends_on = None


def upgrade():
    """Create table."""
    if not migration.schema_has_table('huawei_ac_basic_config'):
        op.create_table(
            'huawei_ac_basic_config',
            sa.Column('id', sa.String(36), primary_key=True, default=uuidutils.generate_uuid),
            sa.Column('config_file', sa.String(255), nullable=False),
            sa.Column('owner', sa.String(128), nullable=False),
            sa.Column('user_group', sa.String(128), nullable=False),
            sa.Column('right', sa.String(10), nullable=False),
            sa.Column('create_time', sa.DateTime, default=sa.func.now()),
            sa.Column('config_value', sa.PickleType, default={}),
            sa.PrimaryKeyConstraint('id')
        )
```

3. 数据库交互类  
   完成数据库模型的定义后，我们还需要定义一个类，里面封装一系列与数据库直接交互的方法，后面所有与数据库打交道的地方均通过此类完成。  
   我们在 *networking_huawei/drivers/ac/db/config_check*包新建 *ac_basic_config_db.py*,代码类似

```python
try:
    from neutron.db import common_db_mixin
except ImportError:
    from networking_huawei.drivers.ac.common import common_db_mixin

from networking_huawei.drivers.ac.db.config_check.ac_config_schema import ACBasicConfig
from networking_huawei.drivers.ac.common.neutron_compatible_util import ac_log

logger = ac_log.getLogger(__name__)


class AcBasicConfigDBMixin(common_db_mixin.CommonDbMixin):
    """ac 配置数据库层"""

    @classmethod
    def create(cls, context, data):
        """创建

        :param context: neutron_lib.context.Context,上下文
        :param data: dict,用字典描述资源值，来自于请求体
        :return: ACBasicConfig
        """
        logger.info('[AC]Begin to create ACConfig:%s,context=%s', data, context)
        result = data if isinstance(data, ACBasicConfig) else ACBasicConfig.from_dict(data)
        with context.session.begin(subtransactions=True):
            context.session.add(result)
            context.session.flush()
        logger.info('[AC]create result=%s', result)
        return result

    def get(self, context, pk_id):
        """查询单条数据

        :param context: neutron_lib.context.Context,上下文
        :param pk_id: str,资源ID
        :return: ACBasicConfig
        """
        logger.info('[AC]Begin to get ACConfig:%s,context=%s', pk_id, context)
        result = self._get_by_id(context, ACBasicConfig, pk_id)
        logger.info('[AC]get result=%s', result)
        return result

    def list(self, context, filters=None, **kwargs):
        """查询多条记录

        :param context: neutron_lib.context.Context,上下文
        :param filters: 过滤条件
        :param kwargs: dict,其它键值对参数,如sorts、limit、marker_obj、page_reverse
        :return: List[ACBasicConfig]
        """
        logger.info('[AC]Begin to list ACConfig:context=%s,filters=%s,kwargs=%s', context, filters, kwargs)
        result = self._get_collection_query(context, ACBasicConfig, filters=filters)
        return result

    def delete(self, context, pk_id):
        """删除数据库指定ID的数据

        :param context: neutron_lib.context.Context,上下文
        :param pk_id: str,资源ID
        :return: ACBasicConfig
        """
        logger.info('[AC]Begin to delete ACConfig:%s,context=%s', pk_id, context)
        result = self._get_by_id(context, ACBasicConfig, pk_id)
        with context.session.begin(subtransactions=True):
            context.session.delete(result)
        logger.info('[AC]delete result=%s', result)
        return result
```

### 3.2 扩展(Extensions)

为了剥离与neutron强耦合的部分，*abstract_neutron_service_extensions.py*文件里设计了一个抽象类 **"AbstractServiceExt"**,后面增加新资源的扩展均继承该类。

1. 在 **"networking_huawei/drivers/ac/extensions"** 目录下新建包，在该目录下编写新资源的扩展  
   首先我们新建包: networking_huawei/drivers/ac/extensions/config_check，在该目录下新建python文件：ac_config_ext.py，这里注意文件名和扩展类名有一套规则：
    * 扩展类名需为文件名首字母大写，其余字母小写；具体参考```neutron.api.extensions.ExtensionManager._load_all_extensions_from_path()```

   只有符合这条规则neutron才能根据文件找到相应的扩展类。
   > - 待做：AbstractServiceExt如何剥离neutron关于文件名和扩展类名的规则？

   新建扩展代码如下，其中```get_alias()```方法是控制请求URL中路径的关键方法，在这里URL将类似 **http://controller:port/v2.0/ac_config**

```python
from networking_huawei.drivers.ac.common import constants
from networking_huawei.drivers.ac.extensions.abstract_neutron_service_extensions import AbstractServiceExt


class Ac_config_ext(AbstractServiceExt):
    """extension of ac config"""

    @property
    def attributes(self):
        """资源字段清单"""
        return {self.get_name(): {
            'id': {
                'allow_post': False, 'allow_put': False,
                'validate': {'type:uuid': None},
                'is_visible': True,
                'primary_key': True
            },
            'config_file': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
            'owner': {
                'allow_post': False, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
            'user_group': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
            'right': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:int': None},
                'is_visible': True
            },
            'config_value': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:dict': {}},
                'is_visible': True
            },
            'create_time': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
        }}

    @property
    def plugin(self):
        """扩展对应插件"""
        return self.get_plugin(versions={constants.OPS_K, constants.OPS_M, constants.OPS_EZ_M,
                                         constants.FSP_6_1, constants.FSP_6_3_0, constants.FSP_6_3_1,
                                         constants.FSP_6_5, constants.FSP_6_5_private, constants.FSP_6_5_NFVI,
                                         constants.FSP_8_0_0, constants.FSP_8_0_3})

    def get_alias(self):
        """重载父类名称"""
        return 'ac_config'
```   

### 3.3 插件(plugins)

业务处理代码主要集中在plugin内，所有的plugin均继承 *abstract_neutron_service_plugin.py*文件里设计了一个抽象类 **"AbstractServicePlugin"**
,实现抽象类对应方法即可完成新资源相应的接口。这里以基本的增删查功能为例。

```python
from networking_huawei.drivers.ac.common.neutron_compatible_util import ac_log
from networking_huawei.drivers.ac.db.config_check.ac_basic_config_db import AcBasicConfigDBMixin
from networking_huawei.drivers.ac.extensions.config_check.ac_config_ext import Ac_config_ext
from networking_huawei.drivers.ac.plugins.abstract_neutron_service_plugin import AbstractServicePlugin

LOG = ac_log.getLogger(__name__)


class AcConfigPlugin(AbstractServicePlugin):
    """AC 配置插件类"""

    def __init__(self):
        super(AcConfigPlugin, self).__init__(Ac_config_ext())
        # 数据库
        self.db = AcBasicConfigDBMixin()

    def create_core(self, request, body=None, **kwargs):
        """see AbstractServicePlugin.create_core"""
        LOG.info('[ACConfigCheck]create ac config start:%s,body=%s,kwargs=%s', request, body, kwargs)
        result = self.db.create(request.context, body).show()
        LOG.info('[ACConfigCheck]create success:%s', result)
        return {self.extension.get_alias(): result}

    def show_core(self, request, pk_id, **kwargs):
        """see AbstractServicePlugin.show_core"""
        LOG.info('[ACConfigCheck]show ac config start:%s,body=%s,kwargs=%s', request, pk_id, kwargs)
        result = {self.extension.get_alias(): self.db.get(request.context, pk_id).show()}
        LOG.info('[ACConfigCheck]show success:%s', result)
        return result

    def list_core(self, request, **kwargs):
        """see AbstractServicePlugin.list_core"""
        LOG.info('[ACConfigCheck]list ac config start:%s,kwargs=%s', request, kwargs)
        result = []
        for elem in self.db.list(request.context, **kwargs):
            result.append(elem.show())
        LOG.info('[ACConfigCheck]list success:%s', result)
        return {self.extension.get_alias(): result}

    def delete_core(self, request, pk_id, **kwargs):
        """see AbstractServicePlugin.delete_core"""
        LOG.info('[ACConfigCheck]delete ac config start:%s,id=%s,kwargs=%s', request, pk_id, kwargs)
        context = request.context
        if pk_id == 'all':
            for elem in self.db.list(context):
                self.db.delete(context, elem.id)
        else:
            self.db.delete(context, pk_id)
        LOG.info('[ACConfigCheck]delete success:%s', pk_id)
```

### 3.4 增加neutron命令行支持

```python
import json
from neutronclient.common import extension
from networking_huawei.drivers.ac.extensions.config_check.ac_config_ext import Ac_config_ext


class AcConfigClientExt(extension.NeutronClientExtension):
    """初始化操作AC 配置命令对应插件的接口相关信息"""
    resource = Ac_config_ext().get_alias()
    resource_plural = '%s' % resource
    object_path = '/%s' % resource_plural
    resource_path = '/%s/%%s' % resource_plural
    versions = ['2.0']
    allow_names = False


class CreateAcConfig(extension.ClientExtensionCreate, AcConfigClientExt):
    """创建ac配置"""
    shell_command = 'acctrl-config-save'

    def add_known_arguments(self, parser):
        """命令行参数"""
        parser.add_argument('--config', help='config.')
        return parser

    def args2body(self, parsed_args):
        """将命令行参数转成请求体

        :param parsed_args: Namespace,命令行参数
        :return: dict
        """
        return {self.resource: json.dumps(parsed_args.config)}


class DeleteAcConfig(extension.ClientExtensionDelete, AcConfigClientExt):
    """删除ac配置"""
    # if id is all,will clear all config.
    shell_command = 'acctrl-config-delete'


class ShowAcConfig(extension.ClientExtensionShow, AcConfigClientExt):
    """查询ac指定的配置"""
    shell_command = 'acctrl-config-show'


class ListAcConfig(extension.ClientExtensionList, AcConfigClientExt):
    """查询ac配置"""
    shell_command = 'acctrl-config-list'
    list_columns = ['id', 'config_file', 'owner', 'user_group', 'right', 'create_time', 'config_value']
```

### 3.4 修改配置

在配置文件 **"networking-huawei/setup.cfg"** 配置新增的扩展。

在 *"entry_points"* 配置项的 **"neutron.service_plugins”** 增加 **"huawei_ac_config =
networking_huawei.drivers.ac.plugins.config_check.ac_config_plugin:AcConfigPlugin"**

```ini
[entry_points]
neutron.service_plugins = huawei_ac_config = networking_huawei.drivers.ac.plugins.config_check.ac_config_plugin:AcConfigPlugin
```

### 3.5 安装脚本

openstack 还需要修改

1. 修改openstack安装脚本 **"networking_huawei_install.sh"**,修改相关配置文件:

```shell
# add huawei_ac_config plugin
SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_config"
API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$PYTHON_PATH/networking_huawei/drivers/ac/extensions/config_check"
```

2. 修改 openstack 卸载脚本 **"networking_huawei_uninstall.sh"**:

```shell
##service_plugins
echo "  unable huawei service_plugins"
service_plugins_name=service_plugins
huawei_service_plugins_list=(huawei_ac_router huawei_ac_ext huawei_ac_fwaas huawei_ac_ipsecvpn huawei_ac_qos huawei_ac_dnat huawei_ac_vpc_connection huawei_ac_bgp_route huawei_ac_l2br huawei_ac_snat huawei_ac_portforwarding huawei_ac_flow_mirror huawei_ac_sync_result huawei_ac_compare_result huawei_ac_config)

```

## 4. 部署测试

1. 上传代码到测试环境

2. 修改配置，注册新的插件
   - 修改 ***"entry_points.txt"*** 文件(参考路径：*
     “/lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info/entry_points.txt”*),本地对应修改 *"setup.cfg"* 文件  
     在文件中标签为 *"[neutron.service_plugins]"* 的配置项中添加要注册的新插件，参考范例
    ```text
    [neutron.service_plugins]
    huawei_ac_config = networking_huawei.drivers.ac.plugins.config_check.ac_config_plugin:AcConfigPlugin
    huawei_ac_config_check = networking_huawei.drivers.ac.plugins.config_check.config_check_plugin:AcConfigCheckPlugin
    ```

   - 修改 ***"neutron.conf"*** 文件，增加新增插件（参考路径：*/etc/neutron/neutron.conf*)  
     在文件中 *"service_plugins"* 的配置项中添加要注册的新插件，参考范例
    ```text
    service_plugins = huawei_ac_router,huawei_ac_ext,...,huawei_ac_config,huawei_ac_config_check
    api_extensions_path = /usr/lib/python2.7/site-packages/networking_huawei/drivers/ac/extensions/exroute:...:/usr/lib/python2.7/site-packages/networking_huawei/drivers/ac/extensions/config_check
    ```

3. 升级数据库  
   将 *"networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/"* 下的文件上传到服务器相应目录后，执行下面命令升级数据库：
    ```shell
    neutron-db-manage --subproject networking-huawei upgrade head
    ```
   登录数据库，查看有没有成功创建相应表，neutron库里面的表 *"huawei_ac_alembic_version“* 的版本号更新成最新的版本。

    - 失败回滚：修改neutron库里面的表 *"huawei_ac_alembic_version“* 的版本号为升级前的版本后再次执行升级命令。

3. 重启服务

```shell
systemctl restart neutron-server
```

4. 导入环境变量

```shell
source ~/admin-openrc
# neutron net-list #测试环境变量是否导入成功
```

5. 获取Token

```shell
export TOKEN=`openstack token issue | grep -w id |awk '{print $4}'`
```

6. 接口测试  
   假设neutron服务为“controller:9696”

```shell
# 测试环境是否正常 
curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X GET http://controller:9696/v2.0/networks

# 查询
curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X GET http://controller:9696/v2.0/ac_config

# 创建
curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X POST http://controller:9696/v2.0/ac_config -d '{"ac_config":{"config_file": "config_file", "owner": "owner", "user_group": "user_group", "right": "right", "config_value": ""}}'

# 查询指定ID
curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X GET http://controller:9696/v2.0/ac_config/id

# 删除指定ID
curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X DELETE http://controller:9696/v2.0/ac_config/id

# 删除所有
curl -i --insecure -H "Accept: application/json" -H "User-Agent: python-neutronclient" -H "X-Auth-Token: $TOKEN" -X DELETE http://controller:9696/v2.0/ac_config/all
```  

7. 命令行 需要先注册客户端插件命令行(neutron寻找客户端所有命令方法:```neutronclient.shell.NeutronShell._register_extensions()```）
    - 修改 ***"entry_points.txt"*** 文件（参考路径：*
      /lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info/entry_points.txt* ）,本地对应修改 *"setup.cfg"* 文件
    ```text
    [neutronclient.extension]
    ac_config_check = networking_huawei.drivers.ac.neutron_client.config_check_client
    ```

    - 测试命令行
    ```shell
    neutron acctrl-config-list
    neutron acctrl-config-save --config '{"right": "-rw-r-----", "config_file": "/etc/neutron/plugins/ml2/ml2_conf.ini", "create_time": "2022-04-02 03:53:45", "user_group": "neutron", "owner": "root", "config_value": {"ml2.extension_drivers": "port_security", "ml2.mechanism_drivers": "huawei_ac_ml2,openvswitch,l2population"}, "id": "9c8e0fc4-ee27-4906-8722-19d0684969ce"}'
    neutron acctrl-config-list
    neutron acctrl-config-delete all
    neutron acctrl-config-list
    ```