#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""REST client to Agile Controller."""

import ssl
from requests.adapters import HTTPAdapter

try:
    from requests.packages.urllib3.poolmanager import PoolManager
except ImportError:
    # PoolManager for Kilo
    from urllib3.poolmanager import PoolManager
from urllib3.util.ssl_ import create_urllib3_context
import eventlet
import networking_huawei.drivers.ac.common.constants as ac_constants
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging

requests = eventlet.import_patched('requests.__init__')

LOG = logging.getLogger(__name__)


class HWHTTPSAdapter(HTTPAdapter):
    """HTTPS adapter for Huawei."""

    def __init__(self, cert_file, key_file, password, *args, **kwargs):
        self._cert_file = cert_file
        self._key_file = key_file
        self._password = password
        super(HWHTTPSAdapter, self).__init__(*args, **kwargs)

    def _add_ssl_context(self, kwargs):
        context = create_urllib3_context(ciphers=ac_constants.SUPPORT_CIPHERS)
        context.load_cert_chain(certfile=self._cert_file,
                                keyfile=self._key_file,
                                password=str(self._password))
        kwargs['ssl_context'] = context

    def proxy_manager_for(self, *args, **kwargs):
        """proxy manager for

        :param args: args
        :param kwargs: kwargs
        :return: https adapter
        """
        if self._cert_file:
            self._add_ssl_context(kwargs)
        return super(HWHTTPSAdapter, self).proxy_manager_for(*args, **kwargs)

    def init_poolmanager(self, connections, maxsize, block=False, **kwargs):
        """init poolmanager

        :param connections: connections of https
        :param maxsize: maxsize pool
        :param block: block
        :param kwargs: kwargs
        :return: None
        """
        LOG.debug('[AC] Begin to initialize HWHTTPSAdapter.')
        if self._cert_file:
            self._add_ssl_context(kwargs)
        self._pool_connections = connections
        self._pool_maxsize = maxsize
        self._pool_block = block
        self.poolmanager = PoolManager(num_pools=connections,
                                       maxsize=maxsize, block=block,
                                       ssl_version=ssl.PROTOCOL_SSLv23,
                                       assert_hostname=False)
