#!/usr/bin/env python
# coding=utf-8
"""
# @File : neutron_version_util.py
# @Time : 2022-11-25
"""
import six

from networking_huawei.drivers.ac.common import constants as ac_constants
from networking_huawei.drivers.ac.common import neutron_compatible_util as ncu

try:
    from neutron.common.exceptions import NeutronException
except ImportError:
    from neutron_lib.exceptions import NeutronException


class NeutronVersionInvalid(NeutronException):
    """NeutronVersionInvalid"""
    message = "Invalid ops version: %(version)s"


VALID_OPS_VERSIONS = [
    ac_constants.OPS_K, ac_constants.OPS_L, ac_constants.OPS_M, ac_constants.OPS_N, ac_constants.OPS_O,
    ac_constants.OPS_P, ac_constants.OPS_Q, ac_constants.OPS_R, ac_constants.OPS_T, ac_constants.OPS_EZ_M,
    ac_constants.FSP_6_1, ac_constants.FSP_6_3_0, ac_constants.FSP_6_3_1, ac_constants.FSP_6_5,
    ac_constants.FSP_6_5_private, ac_constants.FSP_6_5_NFVI, ac_constants.FSP_6_5_1,
    ac_constants.FSP_8_0_0, ac_constants.FSP_8_0_3,
    ac_constants.FSP_21_0,
]


class restrict_version(object):
    """ops版本限定注解
    """

    def __init__(self, *versions):
        self.versions = versions
        self._validate()

    def _validate(self):
        for version in self.versions:
            if version not in VALID_OPS_VERSIONS:
                raise NeutronVersionInvalid(version=version)

    def __call__(self, func):
        @six.wraps(func)
        def wrapper(*args, **kwargs):
            if not self.versions or ncu.get_ops_version() in self.versions:
                return func(*args, **kwargs)
            return None

        return wrapper
