#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ramdom util"""

import base64
import time
import threading
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei.drivers.ac.common.util import ACCommonUtil
from networking_huawei.drivers.ac.db.decrypt_factor import decrypt_factor_db
from networking_huawei.drivers.ac.db.dbif import ACdbInterface
from networking_huawei.drivers.ac.encode_convert import convert_to_bytes

RANDOM_SET_INTERVAL = 300

LOG = logging.getLogger(__name__)


def set_factor_random():
    """set factor random"""
    factor_db = decrypt_factor_db.DecryptFactorDbMixin()
    session = ACdbInterface().get_session('write')
    random_dict = {}
    # get secure random slowly for server times,and IO will be Occupy
    # websocket link will be interrupt(if IO is occupied over 30s)
    time.sleep(5)
    random_dict['work_key_random'] = base64.b64encode(
        convert_to_bytes(ACCommonUtil.get_secure_random()))
    time.sleep(15)
    random_dict['work_key_iv_random'] = base64.b64encode(
        convert_to_bytes(ACCommonUtil.get_secure_random()))
    time.sleep(15)
    random_dict['pw_iv_random'] = base64.b64encode(
        convert_to_bytes(ACCommonUtil.get_secure_random()))
    factor_db.update_db_decrypt_factor_for_random(
        session, random_dict)
    index = 0
    keys = ['work_key_random', 'work_key_iv_random', 'pw_iv_random']
    while True:
        time.sleep(RANDOM_SET_INTERVAL)
        LOG.info("Begin to get secure random")
        random_dict[keys[index]] = base64.b64encode(
            convert_to_bytes(ACCommonUtil.get_secure_random()))
        LOG.info("End to get secure random")
        index = (index + 1) % 3
        factor_db.update_db_decrypt_factor_for_random(
            session, random_dict)


def init_get_random():
    """init get random"""
    LOG.debug("Start to get random thread")
    th_ramdom = threading.Thread(target=set_factor_random, name='get_random')
    th_ramdom.start()
    LOG.debug("Start to get random thread done")
