#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACL2brSchema class """


import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base



class ACCompareResultSchema(model_base.BASEV2):
    """ACCompareResultSchema"""
    __tablename__ = 'huawei_ac_compare_results'
    id = sa.Column(sa.String(255), primary_key=True)
    tenant_name = sa.Column(sa.String(255), nullable=True)
    res_name = sa.Column(sa.String(255), nullable=True)
    res_type = sa.Column(sa.String(50), nullable=False)
    create_time = sa.Column(sa.String(50), nullable=True)
    update_time = sa.Column(sa.String(50), nullable=True)
    status = sa.Column(sa.String(100), nullable=False)
