#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACL2brSchema class """


import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base
from oslo_utils import uuidutils


class ACL2brSchema(model_base.BASEV2):
    """ACL2brSchema"""
    __tablename__ = 'huawei_ac_l2brs'
    id = sa.Column(sa.String(255),
                   primary_key=True,
                   default=uuidutils.generate_uuid)
    tenant_id = sa.Column(sa.String(255), nullable=False)
    name = sa.Column(sa.String(64))
    device_id = sa.Column(sa.String(255))
    device_mac = sa.Column(sa.String(64))
    device_ip = sa.Column(sa.String(64))
    interface_id = sa.Column(sa.String(255))
    vlan_id = sa.Column(sa.Integer)
    vni = sa.Column(sa.Integer)
    network_id = sa.Column(sa.String(255))
    status = sa.Column(sa.String(16))
