#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: c4818a243f6f
Revises: 270980b1080d
Create Date: 2016-07-25 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from oslo_utils import uuidutils
from neutron.db import migration

from networking_huawei.drivers.ac.common import constants as ac_const
from networking_huawei.drivers.ac.db.utcnow import utcnow

# revision identifiers, used by Alembic.
revision = 'c4818a243f6f'
down_revision = '270980b1080d'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Make table huawei_ac_plugin.
    Make table huawei_ac_validation.
    Make table huawei_ac_neutron_state.
    Make table huawei_ac_cluster.
    Make table huawei_ac_l2brs.
    """
    if not migration.schema_has_table('huawei_ac_plugin'):
        create_table_ac_plugin()

    if not migration.schema_has_table('huawei_ac_validation'):
        op.create_table(
            'huawei_ac_validation',
            sa.Column('res_seq_num', sa.BigInteger),
            sa.Column('dep_seq_num', sa.BigInteger, nullable=False),
            sa.PrimaryKeyConstraint('res_seq_num', 'dep_seq_num')
        )

    if not migration.schema_has_table('huawei_ac_neutron_state'):
        create_table_ac_neutron_state()

    if not migration.schema_has_table('huawei_ac_cluster'):
        op.create_table(
            'huawei_ac_cluster',
            sa.Column('id', sa.Integer, nullable=False),
            sa.Column('active_ip', sa.String(256), nullable=False),
            sa.Column('update_time', sa.DateTime, default=utcnow(),
                      onupdate=utcnow()),
            sa.PrimaryKeyConstraint('id')
        )

    if not migration.schema_has_table('huawei_ac_l2brs'):
        op.create_table(
            'huawei_ac_l2brs',
            sa.Column('id', sa.String(255), primary_key=True,
                      default=uuidutils.generate_uuid),
            sa.Column('tenant_id', sa.String(255), nullable=False),
            sa.Column('name', sa.String(64)),
            sa.Column('device_id', sa.String(255)),
            sa.Column('device_mac', sa.String(64)),
            sa.Column('device_ip', sa.String(64)),
            sa.Column('interface_id', sa.String(255)),
            sa.Column('vlan_id', sa.Integer),
            sa.Column('vni', sa.Integer),
            sa.Column('network_id', sa.String(255)),
            sa.Column('status', sa.String(16)),
            sa.PrimaryKeyConstraint('id')
        )


def create_table_ac_neutron_state():
    """Make table :huawei_ac_neutron_state"""
    op.create_table(
        'huawei_ac_neutron_state',
        sa.Column('neutron_id', sa.Integer, autoincrement=True),
        sa.Column('neutron_name', sa.String(256), nullable=False),
        sa.Column('state', sa.Enum(
            ac_const.NORMAL, ac_const.CONSISTENCY_CHECK, ac_const.ERROR,
            ac_const.NEUTRON_SYNC, name='neutron_state'),
                  nullable=False, default=ac_const.NORMAL),
        sa.Column('sync_res', sa.String(86), default=''),
        sa.Column('is_leader', sa.Boolean, default=False),
        sa.Column('sync_type', sa.Enum(
            ac_const.NEUTRON_SYNC_NONE, ac_const.NEUTRON_SYNC_INTERVAL,
            ac_const.NEUTRON_SYNC_INTERVAL_AND_RESTART,
            ac_const.NEUTRON_SYNC_RESTART, name='neutron_sync_type'),
                  nullable=False, default=ac_const.NEUTRON_SYNC_NONE),
        sa.Column('create_time', sa.DateTime, default=utcnow()),
        sa.Column('access_time', sa.DateTime, default=utcnow(),
                  onupdate=utcnow()),
        sa.PrimaryKeyConstraint('neutron_id')
    )


def create_table_ac_plugin():
    """Make table :huawei_ac_plugin"""
    op.create_table(
        'huawei_ac_plugin',
        sa.Column('seq_num', sa.BigInteger, autoincrement=True),
        sa.Column('neutron_id', sa.Integer, nullable=False),
        sa.Column('res_uuid', sa.String(36)),
        sa.Column('res_type', sa.String(50), nullable=False),
        sa.Column('user_oper', sa.String(50), nullable=False),
        sa.Column('data', sa.PickleType, nullable=True),
        sa.Column('retry_count', sa.Integer, nullable=False),
        sa.Column('create_time', sa.DateTime, default=utcnow()),
        sa.Column('update_time', sa.DateTime, default=utcnow(),
                  onupdate=utcnow()),
        sa.Column('state', sa.Enum(
            ac_const.WAIT, ac_const.IN_PROCESS, ac_const.COMPLETE,
            ac_const.SUSPEND, ac_const.ERROR_RETRY, ac_const.NEUTRON_SYNC,
            name='plugin_state'), nullable=False, default=ac_const.WAIT),
        sa.Column('reason', sa.String(100), default=''),
        sa.PrimaryKeyConstraint('seq_num')
    )
