#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: d5d93d9ca9e6
Revises: c4818a243f6f
Create Date: 2017-01-24 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'd5d93d9ca9e6'
down_revision = 'c4818a243f6f'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Make table huawei_ac_config.
    Make table huawei_ac_port_attributes.
    Make table huawei_ac_res_attributes.
    Make table huawei_ac_vpc_connection.
    Make table huawei_ac_bgp_route.
    Make table huawei_ac_bare_metal_bond.
    """
    if not migration.schema_has_table('huawei_ac_config'):
        op.create_table(
            'huawei_ac_config',
            sa.Column('key', sa.String(64), nullable=False),
            sa.Column('value', sa.Integer, nullable=False, default=0),
            sa.Column('comment', sa.String(128), nullable=True),
            sa.PrimaryKeyConstraint('key'))

    if not migration.schema_has_table('huawei_ac_port_attributes'):
        op.create_table('huawei_ac_port_attributes',
                        sa.Column('uuid', sa.String(36)),
                        sa.Column('network_id', sa.String(36), nullable=False),
                        sa.Column('create_time', sa.DateTime),
                        sa.Column('update_time', sa.DateTime),
                        sa.PrimaryKeyConstraint('uuid'))

    if not migration.schema_has_table('huawei_ac_res_attributes'):
        op.create_table('huawei_ac_res_attributes',
                        sa.Column('uuid', sa.String(36)),
                        sa.Column('res_type', sa.String(50), nullable=False),
                        sa.Column('create_time', sa.DateTime),
                        sa.Column('update_time', sa.DateTime),
                        sa.PrimaryKeyConstraint('uuid', 'res_type'))

    if not migration.schema_has_table('huawei_ac_vpc_connection'):
        op.create_table(
            'huawei_ac_vpc_connection',
            sa.Column('id', sa.String(36)),
            sa.Column('tenant_id', sa.String(36), nullable=False),
            sa.Column('name', sa.String(255)),
            sa.Column('description', sa.String(255)),
            sa.Column('local_router', sa.String(36), nullable=False),
            sa.Column('local_subnets', sa.PickleType, nullable=False),
            sa.Column('peer_router', sa.String(36), nullable=False),
            sa.Column('peer_subnets', sa.PickleType, nullable=False),
            sa.Column('status', sa.String(16), nullable=False),
            sa.PrimaryKeyConstraint('id'))

    if not migration.schema_has_table('huawei_ac_bgp_route'):
        create_table_ac_dgp_route()

    if not migration.schema_has_table('huawei_ac_bare_metal_bond'):
        op.create_table(
            'huawei_ac_bare_metal_bond',
            sa.Column('port_id', sa.String(255), primary_key=True,
                      nullable=False),
            sa.Column('bond_mode', sa.String(64), nullable=False,
                      default="active-backup"))


def create_table_ac_dgp_route():
    """Make table:huawei_ac_bgp_route"""
    op.create_table(
        'huawei_ac_bgp_route',
        sa.Column('id', sa.String(36)),
        sa.Column('tenant_id', sa.String(36), nullable=False),
        sa.Column('name', sa.String(255), nullable=False),
        sa.Column('description', sa.String(255)),
        sa.Column('router_id', sa.String(36), nullable=False),
        sa.Column('router_interface_id', sa.String(36), nullable=False),
        sa.Column('peer_ip_address', sa.String(64), nullable=False),
        sa.Column('peer_as_number', sa.String(36), nullable=False),
        sa.PrimaryKeyConstraint('id')
    )
