#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: l5c8h23ad17g
Revises: n6e231g5ed2c
Create Date: 2019-03-18 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'l5c8h23ad17g'
down_revision = 'n6e231g5ed2c'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Add column peer6_fw_enable to table huawei_ac_exroute.
    """
    if not migration.schema_has_column('huawei_ac_exroute', 'peer6_fw_enable'):
        op.add_column(
            'huawei_ac_exroute',
            sa.Column('peer6_fw_enable', sa.Boolean, nullable=True)
        )
