#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: n7f583v2rf6h
Revises: m5c010p0aw5a
Create Date: 2019-06-13 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'n7f583v2rf6h'
down_revision = 'm5c010p0aw5a'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Alter column comment to String(128) of table huawei_ac_exroute.
    """
    if migration.schema_has_column('huawei_ac_config', 'comment'):
        op.alter_column(
            'huawei_ac_config', 'comment',
            existing_type=sa.String(128),
            type_=sa.String(255)
        )
