#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: od3758325bbd
Revises: n7f583v2rf6h
Create Date: 2019-07-02 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'od3758325bbd'
down_revision = 'n7f583v2rf6h'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Add column exsubnet_id to table huawei_ac_bgp_route.
    Add column local_as_number to table huawei_ac_bgp_route.
    """
    if not migration.schema_has_column('huawei_ac_bgp_route', 'exsubnet_id'):
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('exsubnet_id', sa.String(length=36), nullable=True)
        )
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('local_as_number', sa.String(length=36), nullable=True)
        )
