#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: ryvh5e4u3hsj
Revises: q3f739v7g3uq
Create Date: 2020-02-05 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'ryvh5e4u3hsj'
down_revision = 'q3f739v7g3uq'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_tap_services.
    Create table huawei_ac_tap_flows.
    """
    if not migration.schema_has_table('huawei_ac_tap_services'):
        op.create_table(
            'huawei_ac_tap_services',
            sa.Column('id', sa.String(length=48), nullable=False,
                      primary_key=True),
            sa.Column('tenant_id', sa.String(length=48), nullable=False),
            sa.Column('name', sa.String(length=255), nullable=False),
            sa.Column('description', sa.String(length=255), nullable=True),
            sa.Column('port_id', sa.String(length=48), nullable=True),
            sa.Column('remote_v4ip', sa.String(length=32), nullable=True),
            sa.Column('remote_v6ip', sa.String(length=48), nullable=True)
        )

    if not migration.schema_has_table('huawei_ac_tap_flows'):
        op.create_table(
            'huawei_ac_tap_flows',
            sa.Column('id', sa.String(length=48), nullable=False,
                      primary_key=True),
            sa.Column('tenant_id', sa.String(length=48), nullable=False),
            sa.Column('name', sa.String(length=255), nullable=False),
            sa.Column('description', sa.String(length=255), nullable=True),
            sa.Column('source_port', sa.String(length=48), nullable=False),
            sa.Column('destination_v4ip_prefix', sa.String(length=32),
                      nullable=True),
            sa.Column('destination_v6ip_prefix', sa.String(length=48),
                      nullable=True),
            sa.Column('direction', sa.String(length=5), nullable=False),
            sa.Column('tap_service_id', sa.String(length=48), nullable=False)
        )
