#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: w2a4efedcag8
Revises: w7t5ap9f2xdk
Create Date: 2020-09-7 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'w2a4efedcag8'
down_revision = 'w7t5ap9f2xdk'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Add column fw_enabled to table huawei_ac_vpc_connection.
    """
    if not migration.schema_has_column('huawei_ac_vpc_connection',
                                       'fw_enabled'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('fw_enabled', sa.Boolean, nullable=True)
        )
