#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: x2e4ffedcag4
Revises: w2a4efedcag8
Create Date: 2020-09-7 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration
from networking_huawei.drivers.ac.db.utcnow import utcnow

# revision identifiers, used by Alembic.
revision = 'x2e4ffedcag4'
down_revision = 'w2a4efedcag8'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_failed_resources.
    """
    if not migration.schema_has_table('huawei_ac_failed_resources'):
        op.create_table(
            'huawei_ac_failed_resources',
            sa.Column('id', sa.String(36), nullable=False),
            sa.Column('res_type', sa.String(64)),
            sa.Column('operation', sa.String(64)),
            sa.Column('failed_time', sa.DateTime, default=utcnow()),
            sa.Column('retry_count', sa.Integer),
            sa.PrimaryKeyConstraint('id')
        )
