# !/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
"""Huawei AC bfd ex-route

Revision ID: x6ehffeddag6
Revises: x6ehffeddag5
Create Date: 2022-06-25 16:37
"""

import sqlalchemy as sa
from alembic import op

from neutron.db import migration

revision = 'x6ehffeddag6'
down_revision = 'x6ehffeddag5'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    表 huawei_ac_exroute：保存共享扩展路由信息.
    """
    if not migration.schema_has_column('huawei_ac_exroute', 'source_ips'):
        op.add_column('huawei_ac_exroute', sa.Column('source_ips', sa.PickleType, nullable=True))
        op.add_column('huawei_ac_exroute', sa.Column('bfd', sa.Boolean, default=True, nullable=False))
        op.add_column('huawei_ac_exroute', sa.Column('bfd_name', sa.String(length=64), nullable=True))
        op.add_column('huawei_ac_exroute', sa.Column('preference', sa.Integer, nullable=True))
        op.add_column('huawei_ac_exroute', sa.Column('interface_name', sa.String(length=255), nullable=True))
