#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""schema"""

import sqlalchemy as sa
try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base
from networking_huawei.drivers.ac.common import constants as ac_const
from networking_huawei.drivers.ac.db.utcnow import utcnow


class ACPluginSchema(model_base.BASEV2):
    """ACPluginSchema"""
    __tablename__ = 'huawei_ac_plugin'

    seq_num = sa.Column(sa.BigInteger, nullable=False, primary_key=True,
                        autoincrement=True)
    neutron_id = sa.Column(sa.Integer, nullable=False)
    res_uuid = sa.Column(sa.String(36))
    res_type = sa.Column(sa.String(50), nullable=False)
    user_oper = sa.Column(sa.String(50), nullable=False)
    data = sa.Column(sa.PickleType(protocol=2), nullable=True)
    retry_count = sa.Column(sa.Integer, nullable=False)
    create_time = sa.Column(sa.DateTime, default=utcnow())
    update_time = sa.Column(sa.DateTime, default=utcnow(), onupdate=utcnow())
    state = sa.Column(sa.Enum(ac_const.WAIT, ac_const.IN_PROCESS,
                              ac_const.COMPLETE, ac_const.SUSPEND,
                              ac_const.ERROR_RETRY, ac_const.NEUTRON_SYNC),
                      nullable=False, default=ac_const.WAIT)
    reason = sa.Column(sa.String(100), default='')


class ACValidationSchema(model_base.BASEV2):
    """ACValidationSchema"""
    __tablename__ = 'huawei_ac_validation'

    res_seq_num = sa.Column(sa.BigInteger, nullable=False, primary_key=True)
    dep_seq_num = sa.Column(sa.BigInteger, nullable=False, primary_key=True)


class ACNeutronStateSchema(model_base.BASEV2):
    """ACNeutronStateSchema"""
    __tablename__ = 'huawei_ac_neutron_state'

    neutron_id = sa.Column(sa.Integer, primary_key=True,
                           autoincrement=True)
    neutron_name = sa.Column(sa.String(256), nullable=False)
    state = sa.Column(sa.Enum(ac_const.NORMAL, ac_const.NEUTRON_SYNC,
                              ac_const.CONSISTENCY_CHECK, ac_const.ERROR),
                      nullable=False, default=ac_const.NORMAL)
    sync_res = sa.Column(sa.String(86), default='')
    is_leader = sa.Column(sa.Boolean, default=False)
    create_time = sa.Column(sa.DateTime, default=utcnow())
    access_time = sa.Column(sa.DateTime, default=utcnow(), onupdate=utcnow())
    sync_type = sa.Column(sa.Enum(ac_const.NEUTRON_SYNC_NONE,
                                  ac_const.NEUTRON_SYNC_INTERVAL,
                                  ac_const.NEUTRON_SYNC_RESTART,
                                  ac_const.NEUTRON_SYNC_INTERVAL_AND_RESTART),
                          nullable=False, default=ac_const.NEUTRON_SYNC_NONE)
    ac_connection_state = sa.Column(sa.Integer, nullable=True)


class ACClusterSchema(model_base.BASEV2):
    """ACClusterSchema"""
    __tablename__ = 'huawei_ac_cluster'

    id = sa.Column(sa.Integer, nullable=False, primary_key=True)
    active_ip = sa.Column(sa.String(256), nullable=False)
    update_time = sa.Column(sa.DateTime, default=utcnow(), onupdate=utcnow())


class ACConfigSchema(model_base.BASEV2):
    """ACConfigSchema"""
    __tablename__ = 'huawei_ac_config'

    key = sa.Column(sa.String(64), nullable=False, primary_key=True)
    value = sa.Column(sa.Integer, nullable=False, default=0)
    comment = sa.Column(sa.String(128), nullable=True)


class ACPortAttributes(model_base.BASEV2):
    """ACPortAttributes"""
    __tablename__ = 'huawei_ac_port_attributes'

    uuid = sa.Column(sa.String(36), primary_key=True)
    network_id = sa.Column(sa.String(36), nullable=False)
    create_time = sa.Column(sa.DateTime)
    update_time = sa.Column(sa.DateTime)


class ACResourceAttributes(model_base.BASEV2):
    """ACResourceAttributes"""
    __tablename__ = 'huawei_ac_res_attributes'

    uuid = sa.Column(sa.String(36), primary_key=True)
    res_type = sa.Column(sa.String(50), nullable=False, primary_key=True)
    create_time = sa.Column(sa.DateTime)
    update_time = sa.Column(sa.DateTime)


class ACBMbondmodeSchema(model_base.BASEV2):
    """ACBMbondmodeSchema"""
    __tablename__ = 'huawei_ac_bare_metal_bond'

    port_id = sa.Column(sa.String(255), nullable=False, primary_key=True)
    bond_mode = sa.Column(sa.String(64), nullable=False,
                          default=ac_const.BOND_MODE_LIST[
                              ac_const.BOND_MODE_1])


class ACNeutronSyncSchema(model_base.BASEV2):
    """ACNeutronSyncSchema"""
    __tablename__ = 'huawei_ac_neutron_sync'

    sync_id = sa.Column(
        'sync_id', sa.BigInteger, primary_key=True, autoincrement=True)
    sync_start_time = sa.Column(
        'sync_start_time', sa.DateTime, default=sa.func.now())
    expected_completion_time = sa.Column(
        'expected_completion_time', sa.DateTime, default=sa.func.now())
    hostname = sa.Column('hostname', sa.String(255), nullable=True)
    sync_extension_a = sa.Column(
        'sync_extension_a', sa.String(255), nullable=True)
    sync_extension_b = sa.Column(
        'sync_extension_b', sa.String(255), nullable=True)
    sync_extension_c = sa.Column(
        'sync_extension_c', sa.String(255), nullable=True)
    sync_end_time = sa.Column(
        'sync_end_time', sa.DateTime, default=sa.func.now())


class ACDecryptFactorSchema(model_base.BASEV2):
    """ACDecryptFactorSchema"""
    __tablename__ = 'huawei_ac_decrypt_factor'

    id = sa.Column('id', sa.String(128), primary_key=True, nullable=False)
    pw_key = sa.Column('pw_key', sa.String(255), nullable=True)
    pw_iv = sa.Column('pw_iv', sa.String(255), nullable=True)
    key_iv = sa.Column('key_iv', sa.String(255), nullable=True)


class ACFailedResources(model_base.BASEV2):
    """ACFailedResources"""
    __tablename__ = 'huawei_ac_failed_resources'

    id = sa.Column(sa.String(36), primary_key=True)
    res_type = sa.Column(sa.String(64))
    operation = sa.Column(sa.String(64))
    failed_time = sa.Column(sa.DateTime, default=sa.func.now())
    retry_count = sa.Column(sa.Integer)


class ACAlarms(model_base.BASEV2):
    """ACAlarms"""
    __tablename__ = 'huawei_ac_alarms'

    seq_num = sa.Column(sa.Integer, primary_key=True, autoincrement=True)
    retry_count = sa.Column(sa.Integer)
    description = sa.Column(sa.PickleType(protocol=2), nullable=True)
    inner_id = sa.Column(sa.String(32))
    type = sa.Column(sa.String(32))
    level = sa.Column(sa.String(32))
    host_id = sa.Column(sa.String(128))
    occur_time = sa.Column(sa.DateTime, default=sa.func.now())


class ACWebsocketMsg(model_base.BASEV2):
    """ACWebsocketMsg"""
    __tablename__ = 'huawei_ac_websocket_msg'

    id = sa.Column(sa.String(36), primary_key=True)
    res_type = sa.Column(sa.String(64))
    operation = sa.Column(sa.String(64), primary_key=True)
    status = sa.Column(sa.String(64))
    msg_time = sa.Column(sa.DateTime, default=sa.func.now(), primary_key=True)
