#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2012 Huawei Technologies Co. Ltd. All rights reserved.
"""encode convert"""

from __future__ import print_function
import six
from oslo_log import log as logging

LOG = logging.getLogger(__name__)


def convert_to_str(input_data):
    """convert to string

    :param input_data: bytes
    :return: sting
    """
    try:
        if six.PY3 and isinstance(input_data, six.binary_type):
            return input_data.decode("cp437")
        return input_data
    except (UnicodeDecodeError, AttributeError):
        return input_data


def convert_to_bytes(input_data):
    """convert to bytes

    :param input_data: string
    :return: bytes
    """
    try:
        if isinstance(input_data, int):
            return bytes([input_data]) if six.PY3 else chr(input_data)
        if isinstance(input_data, six.text_type):
            return input_data.encode("cp437")
        return input_data
    except (UnicodeEncodeError, AttributeError):
        return input_data
