#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""firewall rule addresses"""

from oslo_config import cfg
from neutron.db import common_db_mixin
from neutron.api import extensions
try:
    from neutron.api.extensions import ExtensionDescriptor
except ImportError:
    from neutron_lib.api.extensions import ExtensionDescriptor
from networking_huawei._i18n import _LI
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_ml2_api as api
from networking_huawei.drivers.ac.extensions import firewallrule

extensions.append_api_extensions_path(firewallrule.__path__)
LOG = logging.getLogger(__name__)


SOURCE_IP_ADDRESSES = 'source_ip_addresses'
DESTINATION_IP_ADDRESSES = 'destination_ip_addresses'
SOURCE_PORTS = 'source_ports'
DESTINATION_PORTS = 'destination_ports'

DESCRIPTION = 'extend source ip addresses for firewall rule'

EXTENDED_ATTRIBUTES_2_0 = {
    'firewall_rules': {
        SOURCE_IP_ADDRESSES: {'allow_post': True, 'allow_put': True,
                              'is_visible': True, 'default': None},
        DESTINATION_IP_ADDRESSES: {'allow_post': True, 'allow_put': True,
                                   'is_visible': True, 'default': None},
        SOURCE_PORTS: {'allow_post': True, 'allow_put': True,
                       'default': None, 'is_visible': True},
        DESTINATION_PORTS: {'allow_post': True, 'allow_put': True,
                            'default': None, 'is_visible': True},
    }
}


class Firewallruleaddresses(ExtensionDescriptor):
    """Firewall rule addresses"""
    @classmethod
    def get_name(cls):
        """get_name"""
        return 'firewall_rule_addrs'

    @classmethod
    def get_alias(cls):
        """get_alias"""
        return 'firewall_rule_addrs'

    @classmethod
    def get_description(cls):
        """get_description"""
        return 'extend source ip addresses for firewall rule'

    @classmethod
    def get_namespace(cls):
        """get_namespace"""
        return ''

    @classmethod
    def get_updated(cls):
        """get_updated"""
        return '2018-09-01T12:00:00-00:00'

    def get_extended_resources(self, version):
        """get_extended_resources"""
        if version == "2.0":
            return EXTENDED_ATTRIBUTES_2_0
        return {}


class FwruleipaddressesExtensionDriver(api.ExtensionDriver,
                                       common_db_mixin.CommonDbMixin):
    """Fw rule ip addresses Extension Driver"""
    _supported_extension_alias = 'firewall_rule_addrs'

    def initialize(self):
        """initialize"""
        self.ops_version = cfg.CONF.huawei_ac_config.OPS_version
        LOG.info(_LI('[AC][FwruleipaddressesExtensionDriver] '
                     'initialization complete'))

    @property
    def extension_alias(self):
        """extension_alias"""
        return self._supported_extension_alias
