#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""cloud alarm model"""

from oslo_config import cfg
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)
MAX_LENGTH_DESC = 1000


class CloudAlarmModel(object):
    """CloudAlarmModel"""

    @staticmethod
    def ac_model_format(cloud_alarm):
        """ac_model_format"""
        try:
            alarm_info = {
                'alarm': [{
                    'inner-id': cloud_alarm['inner_id'],
                    'description':
                        str(cloud_alarm['description'])[:MAX_LENGTH_DESC],
                    'type': cloud_alarm['type'],
                    'level': cloud_alarm['level'],
                    'cloud-name': cfg.CONF.huawei_ac_config.cloud_name,
                    'host-id': cloud_alarm['host_id'],
                    'occur-time': cloud_alarm['occur_time'].strftime(
                        '%Y-%m-%dT%H:%M:%S.000+00:00')
                }]
            }
        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return alarm_info
